/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.Filter;
import kd.isc.iscb.platform.core.dc.mq.FilterUtil;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.trace.TraceTask;

public class BizTask {
    private static final String FIELD = "field";
    private static final String FIELDS = "fields";
    private static final String STATE = "state";
    private static final String ENTITY_ISC_MQ_BILL_DATA_TASK = "isc_mq_bill_data_task";
    private static final Log logger = LogFactory.getLog(BizTask.class);

    public static DynamicObject create(Long subscriberId, List<Object> value) {
        DynamicObject subscriber = BusinessDataServiceHelper.loadSingle((Object)subscriberId, (String)"isc_mq_bill_data_sub");
        DynamicObject data_source = subscriber.getDynamicObject("group");
        DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_MQ_BILL_DATA_TASK);
        long id = BizTask.newId();
        task.set("id", (Object)id);
        task.set("number", (Object)Hash.mur24((Object[])new Object[]{id}));
        task.set("subscriber", (Object)subscriber);
        task.set("data_source", (Object)data_source);
        task.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        task.set(STATE, (Object)"C");
        String s = Json.toString(value, (boolean)true);
        task.set("data", (Object)StringUtil.trim((String)s, (int)50));
        task.set("data_tag", (Object)JSON.toJSONString(value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        Util.save(task);
        task = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ISC_MQ_BILL_DATA_TASK);
        return task;
    }

    private static long newId() {
        return IDService.get().genLongId(RequestContext.get().getTenantId(), ENTITY_ISC_MQ_BILL_DATA_TASK);
    }

    public static void start(final DynamicObject task) {
        LightTaskManager.submit(new LightTask(){

            @Override
            public String getId() {
                return task.getPkValue().toString();
            }

            @Override
            public void run() {
                try {
                    TraceStack.run(TraceType.XMQB, task, new TraceTask(){

                        public void run() {
                            BizTask.execute(task);
                        }
                    });
                    task.set("disposed_time", (Object)new Timestamp(System.currentTimeMillis()));
                }
                catch (Exception e) {
                    BizTask.saveErrorLog(task, e);
                }
                finally {
                    Util.save(task);
                }
            }
        });
    }

    private static void execute(DynamicObject task) {
        long subscriberId = D.l((Object)task.get("subscriber_id"));
        DynamicObject subscriber = BusinessDataServiceHelper.loadSingle((Object)subscriberId, (String)"isc_mq_bill_data_sub");
        List dataList = (List)JSON.parse((String)D.s((Object)task.get("data_tag")));
        if (CollectionUtils.isEmpty(dataList)) {
            task.set("judgefields", null);
            BizTask.saveSuccessLog(task, new Response("null", SaveDataType.NOP, null));
            return;
        }
        long metaId = D.l((Object)subscriber.get("meta_data_id"));
        DynamicObject meta = BusinessDataServiceHelper.loadSingleFromCache((Object)metaId, (String)"isc_metadata_schema");
        String entity = meta.getString("full_name");
        Map data = (Map)dataList.get(0);
        Map<String, List<String>> judgeFields = BizTask.prepareJudgeFields(subscriber);
        BizTask.decorateData(subscriber, Collections.singletonList(data));
        BizTask.saveJudgeFieldsValue(task, data, judgeFields);
        Map<String, Object> tar = BizTask.filterValues(data, subscriber.getDynamicObjectCollection(FIELDS));
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingleFromCache((Object)subscriber.getLong("group_id"), (String)"isc_data_source", (String)"id, dblink");
        Map<String, Filter> actionMap = BizTask.prepareFilterAndAction(subscriber, tar);
        try (ConnectionWrapper cn = ConnectionManager.getConnection(dataSource.getLong("dblink_id"));){
            for (Map.Entry<String, Filter> entry : actionMap.entrySet()) {
                String action = entry.getKey();
                Filter filter = entry.getValue();
                if (filter == null || filter.matches(tar)) {
                    Response response = cn.getFactory().doBizAction(cn, entity, tar, judgeFields, Collections.singletonList(action), null);
                    BizTask.saveSuccessLog(task, response);
                    continue;
                }
                tar.put("$reason", ResManager.loadKDString((String)"\u63a8\u9001\u7684\u6570\u636e\u4e0d\u6ee1\u8db3\u8fc7\u6ee4\u6761\u4ef6\uff0c\u6545\u5ffd\u7565\u3002", (String)"BizTask_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                BizTask.saveSuccessLog(task, new Response(null, SaveDataType.NOP, null));
            }
        }
    }

    private static void saveJudgeFieldsValue(DynamicObject task, Map<String, Object> data, Map<String, List<String>> judgeFields) {
        StringBuilder sb = new StringBuilder();
        List<String> list = judgeFields.get("$");
        for (String field : list) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(D.s((Object)data.get(field)));
        }
        task.set("judgefields", (Object)(sb.length() > 180 ? sb.substring(0, 180) : sb.toString()));
    }

    private static Map<String, Object> filterValues(Map<String, Object> src, DynamicObjectCollection c) {
        HashMap<String, Object> tar = new HashMap<String, Object>();
        for (DynamicObject o : c) {
            String filed = o.getString(FIELD);
            BizTask.setValue(src, tar, filed);
        }
        return tar;
    }

    private static void setValue(Map<String, Object> src, Map<String, Object> tar, String filed) {
        int index = filed.indexOf(46);
        if (index < 0) {
            tar.put(filed, src.get(filed));
        } else {
            String entry = filed.substring(0, index);
            String subField = filed.substring(index + 1);
            Object subSrc = src.get(entry);
            if (subSrc == null) {
                tar.put(entry, null);
            } else if (subSrc instanceof List) {
                BizTask.setEntryValue(tar, entry, subField, (List)subSrc);
            } else if (subSrc instanceof Map) {
                Object tarMap = tar.computeIfAbsent(entry, k -> new HashMap());
                BizTask.setValue((Map)subSrc, (Map)tarMap, subField);
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%1$s\u6570\u636e\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u5e94\u4e3alist\u6216map\uff0c\u5b9e\u9645\u4e0a\u662f%2$s", (String)"BizTask_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filed, subSrc.getClass().getSimpleName()));
            }
        }
    }

    private static void setEntryValue(Map<String, Object> tar, String entry, String subField, List<Map<String, Object>> src) {
        int i;
        ArrayList tarEntry = tar.get(entry);
        if (tarEntry == null) {
            tarEntry = new ArrayList();
            for (i = 0; i < src.size(); ++i) {
                tarEntry.add(new HashMap());
            }
            tar.put(entry, tarEntry);
        }
        for (i = 0; i < src.size(); ++i) {
            Map<String, Object> m = src.get(i);
            BizTask.setValue(m, (Map)((List)tarEntry).get(i), subField);
        }
    }

    private static Map<String, List<String>> prepareJudgeFields(DynamicObject subscriber) {
        HashMap<String, List<String>> judgeFields = new HashMap<String, List<String>>();
        for (DynamicObject item : subscriber.getDynamicObjectCollection(FIELDS)) {
            String field = item.getString(FIELD);
            int index = field.lastIndexOf(46);
            if (!D.x((Object)item.get("candidate_key"))) continue;
            BizTask.saveJudgeFields(judgeFields, field, index);
        }
        return judgeFields;
    }

    private static void saveJudgeFields(Map<String, List<String>> judgeFields, String field, int index) {
        if (index < 0) {
            BizTask.innerGetJudgeFields(judgeFields, "$", field);
        } else {
            String entryKey = field.substring(0, index);
            BizTask.innerGetJudgeFields(judgeFields, entryKey, field.substring(index + 1));
        }
    }

    private static void innerGetJudgeFields(Map<String, List<String>> judgeFields, String key, String field) {
        List<String> fields = judgeFields.get(key);
        if (fields == null) {
            fields = new ArrayList<String>();
            fields.add(field);
            judgeFields.put(key, fields);
        } else {
            fields.add(field);
        }
    }

    private static Map<String, Filter> prepareFilterAndAction(DynamicObject subscriber, Map<String, Object> data) {
        TreeMap<String, Filter> action = new TreeMap<String, Filter>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1 == null) {
                    return 1;
                }
                return s1.length() - s2.length();
            }
        });
        DynamicObjectCollection operations = subscriber.getDynamicObjectCollection("operations");
        if (CollectionUtils.isEmpty(operations)) {
            action.put(TableAction._SAVE.name(), null);
            return action;
        }
        for (DynamicObject item : operations) {
            String operation = item.getString("operation");
            if (StringUtil.isEmpty((String)operation)) continue;
            Filter filter = FilterUtil.parseFilter(item.getString("condition"), data);
            int index = operation.indexOf(47);
            action.put(index >= 0 ? operation.substring(0, index) : operation, filter);
        }
        return action;
    }

    private static void decorateData(DynamicObject subscriber, List<Map<String, Object>> dataList) {
        for (Map<String, Object> data : dataList) {
            String script = BizTask.getScript(subscriber);
            if (script != null) {
                BizTask.executeScript(data, script);
            }
            for (DynamicObject item : subscriber.getDynamicObjectCollection(FIELDS)) {
                String field = item.getString(FIELD);
                String defaultValue = D.s((Object)item.get("default_value"));
                if (data.containsKey(field) || defaultValue == null) continue;
                data.put(field, defaultValue);
            }
        }
    }

    private static Object executeScript(Object data, String script) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("$data", data);
        Object value = Script.compile((String)script).eval(ctx);
        return value;
    }

    private static String getScript(DynamicObject o) {
        String script = D.s((Object)o.getString("prehandle_script_tag"));
        if (script == null) {
            script = D.s((Object)o.getString("prehandle_script"));
        }
        return script;
    }

    private static void saveSuccessLog(DynamicObject task, Response response) {
        task.set(STATE, (Object)(SaveDataType.NOP == response.getType() ? "N" : "S"));
        task.set("result", (Object)response.toString());
    }

    private static void saveErrorLog(DynamicObject task, Exception e) {
        String s = StringUtil.toString((Throwable)e);
        task.set(STATE, (Object)"F");
        task.set("stack_trace", (Object)DataCopyTask.trim(s));
        task.set("stack_trace_tag", (Object)(s.length() > 290 ? s : null));
    }

    static {
        Functions.init();
    }
}

