/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.connector.self.triggerhandler.DataFlowEventStarter;
import kd.isc.iscb.platform.core.connector.self.triggerhandler.DataFlowHandler;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class DataFlowRouter {
    private static final LocalMemoryCache cache;

    public static List<Long> startDataFlow(long mqTopicId, List<Map<String, Object>> data) {
        DataFlowEventStarter starter = DataFlowHandler.getDataFlowEventStarter();
        ArrayList<Long> streamIds = new ArrayList<Long>();
        for (Long dataFlowTriggerId : DataFlowRouter.findDataFlow(mqTopicId)) {
            long[] array;
            for (long id : array = starter.start(dataFlowTriggerId, data)) {
                streamIds.add(id);
            }
        }
        return streamIds;
    }

    public static List<Long> findDataFlow(long mqTopicId) {
        if (!DataFlowHandler.isDataFlowReady()) {
            return Collections.emptyList();
        }
        Map<Long, List<Long>> routerMap = DataFlowRouter.getRouterMap();
        List<Long> dataFlowTriggerIds = routerMap.get(mqTopicId);
        if (dataFlowTriggerIds == null) {
            dataFlowTriggerIds = DataFlowRouter.loadRouterMap(mqTopicId);
            routerMap.put(mqTopicId, dataFlowTriggerIds);
        }
        return Collections.unmodifiableList(dataFlowTriggerIds);
    }

    public static void clearCache() {
        String accountId = RequestContext.get().getAccountId();
        cache.remove(new String[]{accountId});
    }

    private static Map<Long, List<Long>> getRouterMap() {
        String accountId = RequestContext.get().getAccountId();
        Map routerMap = (Map)cache.get(accountId);
        if (routerMap == null) {
            cache.put(accountId, (Object)new ReadLockFreeMap());
            routerMap = (Map)cache.get(accountId);
        }
        return routerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Long> loadRouterMap(long mqId) {
        String sql = "SELECT fid FROM t_iscx_datax_trigger  WHERE fevent_type = 'EventModel.MQ' and fenable = '1' and fmq_topic_id = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            List rows = DbUtil.executeList((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{mqId}), (List)D.asList((Object[])new Integer[]{-5}));
            ArrayList<Long> list = new ArrayList<Long>(rows.size());
            for (DataRow row : rows) {
                list.add(D.l((Object)row.get((Object)"fid")));
            }
            ArrayList<Long> arrayList = list;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(360000);
        info.setMaxMemSize(2048);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cache = commonCacheFactory.$getOrCreateLocalMemoryCache("ISC_MQ_DF", "bd", info);
    }
}

