/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dc.mq.MQUtil;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class EntityEventPublisher {
    public static long publish(long listenerId, List<?> list) {
        DynamicObject listener = BusinessDataServiceHelper.loadSingle((Object)listenerId, (String)"isc_mq_bill_data_pub");
        long publisherId = D.l((Object)listener.get("message_queue_id"));
        DynamicObject publisher = BusinessDataServiceHelper.loadSingle((Object)publisherId, (String)"isc_mq_publisher");
        long serverId = D.l((Object)publisher.get("group_id"));
        MessageQueueServer server = MessageQueueManager.get(serverId);
        if (publisher.getBoolean("multi_line")) {
            return EntityEventPublisher.innerPublish(list, listener, publisher, server);
        }
        return EntityEventPublisher.publishMultiple(list, listener, publisher, server);
    }

    private static long publishMultiple(List<?> list, DynamicObject listener, DynamicObject publisher, MessageQueueServer server) {
        long r = 0L;
        for (Object item : list) {
            long t = EntityEventPublisher.innerPublish(item, listener, publisher, server);
            if (t == 0L) continue;
            r = t;
        }
        return r;
    }

    private static long innerPublish(Object data, DynamicObject listener, DynamicObject publisher, MessageQueueServer server) {
        String s = EntityEventPublisher.serialize(data, listener, publisher);
        if (s != null) {
            String data_producer = StringUtil.trim((String)("E:" + listener.getString("number")), (int)50);
            return MQUtil.publish(s, server, publisher, data_producer);
        }
        return 0L;
    }

    private static String serialize(Object data, DynamicObject listener, DynamicObject publisher) {
        String script = EntityEventPublisher.getScript(listener);
        if (script != null && ((data = EntityEventPublisher.executeScript(data, script)) == null || data instanceof String)) {
            return (String)data;
        }
        script = EntityEventPublisher.getScript(publisher);
        if (script != null && ((data = EntityEventPublisher.executeScript(data, script)) == null || data instanceof String)) {
            return (String)data;
        }
        return Json.toString((Object)data, (boolean)true);
    }

    private static Object executeScript(Object data, String script) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("$data", data);
        Object value = Script.compile((String)script).eval(ctx);
        return value;
    }

    private static String getScript(DynamicObject o) {
        String script = D.s((Object)o.getString("format_script_tag"));
        if (script == null) {
            script = D.s((Object)o.getString("format_script"));
        }
        return script;
    }

    static {
        Functions.init();
    }
}

