/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dc.mq.MessageConsumer;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class MessageQueueInitiator {
    private static Log logger = LogFactory.getLog(MessageQueueInitiator.class);

    public static void reset(String tenantId, String accountId, String mqServer) {
        RequestContext ctx = ContextUtil.createRequestContext(accountId, tenantId);
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        try {
            long server = D.l((Object)mqServer);
            MessageQueueInitiator.innerReset(server);
        }
        catch (Throwable e) {
            logger.warn("failed to reset message queue listeners", e);
        }
    }

    public static void resetListeners(List<Object> subscribers) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"isc_mq_subscriber");
        HashSet<Long> mqServers = new HashSet<Long>();
        for (DynamicObject i : BusinessDataServiceHelper.load((Object[])subscribers.toArray(), (DynamicObjectType)type)) {
            mqServers.add(i.getLong("group_id"));
        }
        for (Long mqServer : mqServers) {
            MessageQueueInitiator.resetListeners(mqServer);
        }
    }

    public static void resetListeners(long mqServer) {
        MessageQueueInitiator.innerReset(mqServer);
        RequestContext ctx = RequestContext.get();
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)MessageQueueInitiator.class.getName(), (String)"reset", (Object[])new String[]{ctx.getTenantId(), ctx.getAccountId(), String.valueOf(mqServer)});
    }

    private static void innerReset(long mqServer) {
        MessageQueueManager.get(mqServer).detachListeners();
        MessageConsumer.attachListeners(mqServer);
    }

    public static void disableAllListeners(long mqServer) {
        MessageQueueInitiator.disableUIListeners(mqServer);
        MessageQueueInitiator.resetListeners(mqServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableUIListeners(long mqServer) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "UPDATE t_iscb_mq_subscriber SET fenable='0' WHERE fmq_server=" + mqServer;
            DbUtil.executeUpdate((Connection)cn, (String)sql);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

