/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectorError;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.mq.MessageConsumer;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueType;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;

public class MessageQueueManager {
    private static final Map<String, MessageQueueServer> cache = new ReadLockFreeMap();
    private static Log logger = LogFactory.getLog(MessageQueueManager.class);

    public static MessageQueueServer get(long id) {
        String key = MessageQueueManager.getKey(id);
        MessageQueueServer server = cache.get(key);
        if (server == null) {
            server = MessageQueueManager.createMessageServer(key, id);
        }
        if (IscLicenseUtil.mqHasLicense(id)) {
            return server;
        }
        DynamicObject cfg = server.getConfig();
        String name = cfg.getString("name");
        String number = cfg.getString("number");
        throw ConnectorError.MQ_LICENSE_NOT_READY.create(new String[]{name, number});
    }

    private static String getKey(long id) {
        String accountId = RequestContext.get().getAccountId();
        return accountId + ":" + id;
    }

    private static synchronized MessageQueueServer createMessageServer(String key, long id) {
        MessageQueueServer server = cache.get(key);
        if (server != null) {
            return server;
        }
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_mq_server");
        ConnectorUtil.checkAccountId(cfg);
        server = MessageQueueType.create(cfg);
        cache.put(key, server);
        return server;
    }

    public static void resetServer(String accountId, String tenantId, String id) {
        RequestContext ctx = ContextUtil.createRequestContext(accountId, tenantId);
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        try {
            long mqServer = D.l((Object)id);
            MessageQueueManager.innerReset(mqServer);
        }
        catch (Exception e) {
            logger.warn("failed to reset message server listeners", (Throwable)e);
        }
    }

    public static synchronized void reset(long mqServer) {
        MessageQueueManager.innerReset(mqServer);
        RequestContext ctx = RequestContext.get();
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)MessageQueueManager.class.getName(), (String)"resetServer", (Object[])new String[]{ctx.getAccountId(), ctx.getTenantId(), D.s((Object)mqServer)});
    }

    private static void innerReset(long mqServer) {
        MessageQueueServer server = MessageQueueManager.get(mqServer);
        server.detachListeners();
        cache.remove(MessageQueueManager.getKey(mqServer));
        MessageConsumer.attachListeners(mqServer);
    }

    public static void remove(long mqServer) {
        cache.remove(MessageQueueManager.getKey(mqServer));
    }
}

