/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.IscRuntimeInfo;
import kd.isc.iscb.platform.core.connector.self.SelfConnectionFactory;
import kd.isc.iscb.platform.core.dc.mq.DataFlowRouter;
import kd.isc.iscb.platform.core.dc.mq.MQUtil;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.TaskUtil;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.trace.TraceTask;

public final class MessageReceiver {
    private static final String STATE_FIELD = "fstate";
    private volatile Table msgTable;
    private RequestContext ctx = RequestContext.get();
    private String topic;
    private long subscriber;
    private long mqServer;
    private Charset charset;
    private Script parseScript;
    private String msgDigestScript;
    private MessageQueueServer server;

    public MessageReceiver(String topic, long subscriber, MessageQueueServer messageQueueServer, long mqServer, Charset charset, String parseScript, String msgDigestScript) {
        this.topic = topic;
        this.subscriber = subscriber;
        this.mqServer = mqServer;
        this.charset = charset;
        this.parseScript = parseScript == null ? null : Script.compile((String)parseScript);
        this.msgDigestScript = msgDigestScript;
        this.server = messageQueueServer;
    }

    public MessageQueueServer getMessageQueueServer() {
        return this.server;
    }

    public void handleMessage(byte[] data) {
        String message = new String(data, this.charset);
        RequestContext ctx = this.server.getContext(this.ctx, message);
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        final Table table = this.getMsgTable();
        boolean hasLicense = IscLicenseUtil.mqHasLicense(this.mqServer);
        final Map<String, Object> map = this.prepareForSave(message, hasLicense);
        this.saveData(table, map);
        IscRuntimeInfo info = IscRuntimeInfo.get();
        info.addMqConsumedBytes(data.length);
        info.incMqConsumedCount();
        if (hasLicense) {
            TraceStack.traceMQ(this.topic, new TraceTask(){

                public void run() {
                    LightTaskManager.submit(new InitiateTask(table, MessageReceiver.this.mqServer, MessageReceiver.this.subscriber, MessageReceiver.this.topic, MessageReceiver.this.parseScript, map));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(Table table, Map<String, Object> data) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            TableUtil.insert((Connection)cn, (Table)table, data);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private Map<String, Object> prepareForSave(String message, boolean hasLicense) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long id = IDService.get().genLongId();
        map.put("fid", id);
        map.put(STATE_FIELD, "R");
        map.put("freceived_time", new Timestamp(System.currentTimeMillis()));
        map.put("fmessage_server", this.mqServer);
        map.put("fmessage_queue", this.subscriber);
        map.put("fdata", message.substring(0, Math.min(message.length() - 2, 50)) + "..");
        map.put("fdata_tag", message);
        map.put("freceiver_server", NetUtil.getServerId());
        map.put("fmsg_digest", MQUtil.parseMsgDigest(message, this.msgDigestScript));
        if (!hasLicense) {
            map.put(STATE_FIELD, "F");
            map.put("fstack_trace", ResManager.loadKDString((String)"\u65e0\u8bb8\u53ef", (String)"MessageReceiver_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return map;
    }

    private Table getMsgTable() {
        Table table = this.msgTable;
        if (table != null) {
            return table;
        }
        this.msgTable = table = SelfConnectionFactory.getTable("t_iscb_mq_data_received");
        return table;
    }

    static boolean handleMessage(DynamicObject dataReceived, final long subscriber, final Object data) {
        String number = MQUtil.getNumber(dataReceived);
        long id = dataReceived.getLong("id");
        return (Boolean)TraceStack.run(TraceType.XMQC, number, id, new TraceTask(){

            public Object invoke() {
                return MessageReceiver.innerHandleMessage(subscriber, data);
            }
        });
    }

    private static boolean innerHandleMessage(long subscriber, Object data) {
        List<Object> list;
        List<Object> list2 = list = data instanceof List ? data : Collections.singletonList(data);
        if (!DataFlowRouter.startDataFlow(subscriber, list).isEmpty()) {
            return true;
        }
        List<Long> releaseSfIds = TaskUtil.startSfTasks(subscriber, list);
        if (releaseSfIds.size() > 0) {
            return true;
        }
        List<DynamicObject> dcTasks = TaskUtil.startDcTasks(subscriber, list);
        if (dcTasks.size() > 0) {
            return true;
        }
        List<Object> invokeResults = TaskUtil.invokeApi(subscriber, data);
        if (invokeResults.size() > 0) {
            return true;
        }
        List<DynamicObject> bizTasks = TaskUtil.startBizTasks(subscriber, list);
        return bizTasks.size() > 0;
    }

    static {
        Functions.init();
    }

    private static final class InitiateTask
    implements LightTask {
        private String msgData;
        private long id;
        private String topic;
        private Table msgTable;
        private Script parseScript;
        private long mqServer;
        private long subscriber;

        private InitiateTask(Table table, long mqServer, long subscriber, String topic, Script parseScript, Map<String, Object> map) {
            this.msgData = (String)map.get("fdata_tag");
            this.id = D.l((Object)map.get("fid"));
            this.msgTable = table;
            this.topic = topic;
            this.parseScript = parseScript;
            this.mqServer = mqServer;
            this.subscriber = subscriber;
        }

        @Override
        public String getId() {
            return String.valueOf(this.id);
        }

        public String toString() {
            return this.topic + "@" + this.id;
        }

        @Override
        public void run() {
            try {
                MessageQueueManager.get(this.mqServer);
                Object data = this.parseData();
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"isc_mq_data_received");
                boolean handled = MessageReceiver.handleMessage(obj, this.subscriber, data);
                this.updateState(this.msgTable, this.prepareSuccessStateData(this.id, handled));
            }
            catch (Throwable e) {
                this.updateState(this.msgTable, this.prepareErrorStateData(this.id, e));
            }
        }

        private Object parseData() {
            Object data;
            if (this.parseScript == null) {
                data = Script.parseJson((String)this.msgData);
            } else {
                HashMap<String, String> ctx = new HashMap<String, String>();
                ctx.put("$data", this.msgData);
                data = this.parseScript.eval(ctx);
            }
            return data;
        }

        private Map<String, Object> prepareErrorStateData(long id, Throwable e) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("fid", id);
            data.put("fdisposed_time", new Timestamp(System.currentTimeMillis()));
            data.put(MessageReceiver.STATE_FIELD, "F");
            String s = StringUtil.toString((Throwable)e);
            data.put("fstack_trace", s.substring(0, Math.min(s.length() - 2, 50)) + "..");
            data.put("fstack_trace_tag", s);
            return data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateState(Table table, Map<String, Object> data) {
            Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            try {
                TableUtil.update((Connection)cn, (Table)table, data);
            }
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
            }
        }

        private Map<String, Object> prepareSuccessStateData(long id, boolean handled) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("fid", id);
            data.put("fdisposed_time", new Timestamp(System.currentTimeMillis()));
            if (handled) {
                data.put(MessageReceiver.STATE_FIELD, "S");
            } else {
                data.put(MessageReceiver.STATE_FIELD, "N");
            }
            return data;
        }
    }
}

