/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.sql.Timestamp;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueManager;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class MsgRehandleTask
implements LightTask {
    private static final String DATA_TAG = "data_tag";
    private static final String DISPOSED_TIME = "disposed_time";
    private static final String STACK_TRACE_TAG = "stack_trace_tag";
    private static final String STACK_TRACE = "stack_trace";
    private static final String STATE = "state";
    private DynamicObject dataReceived;
    private String script;
    private String topic;
    private DynamicObject subscriber;

    public MsgRehandleTask(DynamicObject dataReceived, DynamicObject subscriber, String topic, String script) {
        this.dataReceived = dataReceived;
        this.script = script;
        this.topic = topic;
        this.subscriber = subscriber;
    }

    @Override
    public String getId() {
        return D.s((Object)this.dataReceived.get("id"));
    }

    public String toString() {
        return this.topic + "@" + this.getId();
    }

    @Override
    public void run() {
        try {
            if (!this.subscriber.getBoolean("enable")) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"%s:\u8ba2\u9605\u4e3b\u9898\u672a\u542f\u7528\uff0c\u53d1\u9001\u5931\u8d25", (String)"MsgRehandleTask_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.subscriber.getString("number")));
            }
            long mqServer = this.dataReceived.getLong("message_server_id");
            MessageQueueManager.get(mqServer);
            Object data = this.parseMsgData();
            boolean handled = MessageReceiver.handleMessage(this.dataReceived, D.l((Object)this.subscriber.getPkValue()), data);
            this.updateSuccState(handled);
        }
        catch (Throwable e) {
            this.updateErrorState(e);
        }
    }

    private void updateErrorState(Throwable e) {
        this.dataReceived.set(DISPOSED_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        this.dataReceived.set(STATE, (Object)"F");
        String s = StringUtil.toString((Throwable)e);
        this.dataReceived.set(STACK_TRACE, (Object)(s.substring(0, Math.min(s.length() - 2, 50)) + ".."));
        this.dataReceived.set(STACK_TRACE_TAG, (Object)s);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.dataReceived});
    }

    private void updateSuccState(boolean handled) {
        this.dataReceived.set(DISPOSED_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        if (handled) {
            this.dataReceived.set(STATE, (Object)"S");
        } else {
            this.dataReceived.set(STATE, (Object)"N");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.dataReceived});
    }

    private Object parseMsgData() {
        Object data;
        String dataTag = this.dataReceived.getString(DATA_TAG);
        if (this.script == null) {
            data = Script.parseJson((String)dataTag);
        } else {
            HashMap<String, String> ctx = new HashMap<String, String>();
            ctx.put("$data", dataTag);
            data = Script.compile((String)this.script).eval(ctx);
        }
        return data;
    }

    static {
        Functions.init();
    }
}

