/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class ServiceFlowRouter {
    private static final LocalMemoryCache cache;

    public static List<Long> findServiceFlow(long mqId, Map<String, Object> data) {
        Map<Long, List<Long>> routerMap = ServiceFlowRouter.getRouterMap();
        List<Long> sfIds = routerMap.get(mqId);
        if (sfIds == null) {
            sfIds = ServiceFlowRouter.loadRouterMap(mqId);
            routerMap.put(mqId, sfIds);
        }
        return sfIds;
    }

    public static void clearCache() {
        String accountId = RequestContext.get().getAccountId();
        cache.remove(new String[]{accountId});
    }

    private static Map<Long, List<Long>> getRouterMap() {
        String accountId = RequestContext.get().getAccountId();
        Map routerMap = (Map)cache.get(accountId);
        if (routerMap == null) {
            routerMap = new ReadLockFreeMap();
            cache.put(accountId, (Object)routerMap);
        }
        return routerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Long> loadRouterMap(long mqId) {
        String sql = "SELECT A.fid FROM t_isc_service_flow A INNER JOIN t_iscb_mq_subscriber B ON A.fmq_subscriber = B.fid WHERE A.finit_mode = 'MESSAGE' and A.fenable = '1' and A.fmq_subscriber=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(mqId), Collections.singletonList(-5));
            ArrayList<Long> sfIds = new ArrayList<Long>(list.size());
            for (DataRow row : list) {
                Long sfId = D.l((Object)row.get((Object)"fid"));
                sfIds.add(sfId);
            }
            ArrayList<Long> arrayList = sfIds;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    static {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(360000);
        info.setMaxMemSize(512);
        CacheFactory commonCacheFactory = CacheFactory.getCommonCacheFactory();
        cache = commonCacheFactory.$getOrCreateLocalMemoryCache("ISC_MQ_SF", "bd", info);
    }
}

