/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.api.ApiInfo;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.mq.ApiRounter;
import kd.isc.iscb.platform.core.dc.mq.BizTask;
import kd.isc.iscb.platform.core.dc.mq.EntityEventRouter;
import kd.isc.iscb.platform.core.dc.mq.ServiceFlowRouter;
import kd.isc.iscb.platform.core.dc.mq.TriggerRouter;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.n.MessageStarterParser;
import kd.isc.iscb.util.flow.core.Flow;

public class TaskUtil {
    public static List<DynamicObject> startBizTasks(long subscriber, List<Map<String, Object>> dataList) {
        Map<Long, List<Object>> group = TaskUtil.groupBySubscriber(subscriber, dataList);
        return TaskUtil.startBizTasks(group);
    }

    private static List<DynamicObject> startBizTasks(Map<Long, List<Object>> group) {
        ArrayList<DynamicObject> executions = new ArrayList<DynamicObject>(group.size());
        for (Map.Entry<Long, List<Object>> e : group.entrySet()) {
            Long subscriber = e.getKey();
            DynamicObject execution = BizTask.create(subscriber, e.getValue());
            BizTask.start(execution);
            executions.add(execution);
        }
        return executions;
    }

    private static Map<Long, List<Object>> groupBySubscriber(long subscriber, List<Map<String, Object>> list) {
        HashMap<Long, List<Object>> group = new HashMap<Long, List<Object>>();
        for (Map<String, Object> item : list) {
            List<Long> subscribers = EntityEventRouter.findSubscriber(subscriber, item);
            TaskUtil.groupItemByTrigger(list, group, item, subscribers);
        }
        return group;
    }

    public static List<DynamicObject> startDcTasks(long subscriber, List<Map<String, Object>> dataList) {
        Map<Long, List<Object>> triggerDataList = TaskUtil.groupByTrigger(subscriber, dataList);
        return TaskUtil.startDcTasks(triggerDataList);
    }

    private static Map<Long, List<Object>> groupByTrigger(long subscriber, List<Map<String, Object>> list) {
        HashMap<Long, List<Object>> group = new HashMap<Long, List<Object>>();
        for (Map<String, Object> item : list) {
            List<Long> triggers = TriggerRouter.findTrigger(subscriber, item);
            TaskUtil.groupItemByTrigger(list, group, item, triggers);
        }
        return group;
    }

    private static void groupItemByTrigger(List<Map<String, Object>> list, Map<Long, List<Object>> group, Map<String, Object> item, List<Long> triggers) {
        for (Long trigger : triggers) {
            List<Object> items = group.get(trigger);
            if (items == null) {
                items = new ArrayList<Object>(list.size());
                group.put(trigger, items);
            }
            items.add(item);
        }
    }

    private static List<DynamicObject> startDcTasks(Map<Long, List<Object>> group) {
        ArrayList<DynamicObject> executions = new ArrayList<DynamicObject>(group.size());
        for (Map.Entry<Long, List<Object>> e : group.entrySet()) {
            Long trigger = e.getKey();
            DynamicObject execution = DataCopyTask.create(trigger, e.getValue());
            DataCopyTask.start(execution);
            executions.add(execution);
        }
        return executions;
    }

    public static List<Long> startSfTasks(long topicId, List<Map<String, Object>> dataList) {
        Map<Long, List<Object>> group = TaskUtil.groupByServiceFlow(topicId, dataList);
        return TaskUtil.startSfTasks(group);
    }

    private static Map<Long, List<Object>> groupByServiceFlow(long topicId, List<Map<String, Object>> list) {
        HashMap<Long, List<Object>> group = new HashMap<Long, List<Object>>();
        for (Map<String, Object> item : list) {
            List<Long> subscribers = ServiceFlowRouter.findServiceFlow(topicId, item);
            TaskUtil.groupItemByTrigger(list, group, item, subscribers);
        }
        return group;
    }

    private static List<Long> startSfTasks(Map<Long, List<Object>> group) {
        ArrayList<Long> flowInsIds = new ArrayList<Long>();
        for (Map.Entry<Long, List<Object>> e : group.entrySet()) {
            long releasedFlowId = ServiceFlowParser.findReleasedFlowId(e.getKey());
            Flow flow = ServiceFlowParser.getFlow(releasedFlowId);
            MessageStarterParser.MessageStarter messageStarter = (MessageStarterParser.MessageStarter)ServiceFlowParser.getStarter(flow);
            String varName = messageStarter.getAssignValName();
            if (messageStarter.isArray()) {
                flowInsIds.add(TaskUtil.startServiceFlow(releasedFlowId, varName, e.getValue()));
                continue;
            }
            for (Object data : e.getValue()) {
                flowInsIds.add(TaskUtil.startServiceFlow(releasedFlowId, varName, data));
            }
        }
        return flowInsIds;
    }

    private static long startServiceFlow(long releasedFlowId, String varName, Object data) {
        HashMap<String, Object> flowParam = new HashMap<String, Object>();
        flowParam.put(varName, data);
        return ServiceFlowEngine.createAndStart(releasedFlowId, new Object[0], flowParam);
    }

    public static List<Object> invokeApi(long subscriber, Object data) {
        List<ApiInfo> apiInfos = ApiRounter.findApiInfos(subscriber);
        ArrayList<Object> results = new ArrayList<Object>(apiInfos.size());
        for (ApiInfo apiInfo : apiInfos) {
            Object result = apiInfo.invoke(data);
            results.add(result);
        }
        return results;
    }
}

