/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.factory;

import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectorError;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServerFactory;
import kd.isc.iscb.platform.core.dc.mq.kafka.KafkaServer;
import kd.isc.iscb.platform.core.dc.mq.kafka.KafkaUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import org.apache.kafka.clients.admin.AdminClient;

public class ExternalKafkaFactory
implements MessageQueueServerFactory {
    @Override
    public boolean supportCustomParam() {
        return true;
    }

    @Override
    public MessageQueueServer create(DynamicObject cfg) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String bootstrapServers = D.s((Object)cfg.get("bootstrap_servers"));
        if (StringUtil.isEmpty((String)bootstrapServers)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8fde\u63a5\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExternalKafkaFactory_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        bootstrapServers = bootstrapServers.replace(" ", "");
        conf.put("bootstrap.servers", bootstrapServers);
        String customConfig = D.s((Object)cfg.get("custom_config"));
        KafkaUtil.setCustomParam(conf, customConfig);
        KafkaUtil.checkSaslJaas(conf, cfg);
        AdminClient adminClient = AdminClient.create(conf);
        try {
            adminClient.listTopics().names().get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            String name = cfg.getString("name");
            String number = cfg.getString("number");
            throw ConnectorError.KAFKA_CONNECT_ERROR.create((Throwable)e, new String[]{name, number, StringUtil.getMessage((Throwable)e)});
        }
        return new KafkaServer(adminClient, cfg, bootstrapServers, StringUtil.count((String)bootstrapServers, (String)",") + 1);
    }
}

