/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.rabbit;

import com.rabbitmq.client.ConfirmListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.mq.PublishedMessage;

final class MessageConfirmListener
implements ConfirmListener {
    private static Log logger = LogFactory.getLog(MessageConfirmListener.class);
    private final TreeMap<Long, PublishedMessage> confirmSet = new TreeMap();

    MessageConfirmListener() {
    }

    public void handleAck(long seq, boolean multiple) {
        try {
            if (multiple) {
                for (PublishedMessage msg : this.removeMultiple(seq)) {
                    this.setSuccess(msg);
                }
            } else {
                PublishedMessage msg = this.remove(seq);
                this.setSuccess(msg);
            }
        }
        catch (Throwable e) {
            logger.warn("handleAck failed.", e);
        }
    }

    private void setSuccess(PublishedMessage msg) {
        try {
            msg.setSuccess();
        }
        catch (Throwable e) {
            logger.warn("handleAck failed. id=" + msg.getId(), e);
        }
    }

    public void handleNack(long seq, boolean multiple) {
        try {
            if (multiple) {
                for (PublishedMessage msg : this.removeMultiple(seq)) {
                    this.setLeaked(msg);
                }
            } else {
                PublishedMessage msg = this.remove(seq);
                this.setLeaked(msg);
            }
        }
        catch (Throwable e) {
            logger.warn("handleNack failed.", e);
        }
    }

    private void setLeaked(PublishedMessage msg) {
        try {
            msg.setFailed(null);
        }
        catch (Throwable e) {
            logger.warn("handleNack failed. id=" + msg.getId(), e);
        }
    }

    private synchronized PublishedMessage remove(long tag) {
        return this.confirmSet.remove(tag);
    }

    private synchronized Collection<PublishedMessage> removeMultiple(long tag) {
        SortedMap<Long, PublishedMessage> head = this.confirmSet.headMap(tag + 1L);
        ArrayList<PublishedMessage> entries = new ArrayList<PublishedMessage>(head.size());
        entries.addAll(head.values());
        head.clear();
        return entries;
    }

    synchronized void monitor(long tag, PublishedMessage msg) {
        this.confirmSet.put(tag, msg);
    }

    synchronized void rollback(long tag) {
        this.confirmSet.remove(tag);
    }

    synchronized void commit(long tag) {
    }
}

