/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.rabbit;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.rabbitmq.RabbitmqFactory;
import kd.isc.iscb.platform.core.connector.ConnectorError;
import kd.isc.iscb.platform.core.dc.mq.MessageQueueServer;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;
import kd.isc.iscb.platform.core.dc.mq.PublishedMessage;
import kd.isc.iscb.platform.core.dc.mq.rabbit.MessageConfirmListener;
import kd.isc.iscb.platform.core.dc.mq.rabbit.MessageConsumer;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class RabbitMQ
implements MessageQueueServer {
    private static Log logger = LogFactory.getLog(MessageConsumer.class);
    public static final String SPECIAL_TAG = "$PLATFORM";
    private Map<String, Publisher> publishers = new ReadLockFreeMap();
    private Map<String, Channel> consumers = new HashMap<String, Channel>();
    private ConnectionFactory factory;
    private Connection cn;
    private DynamicObject cfg;
    private static final String EXCHANGE_NAME = "exchangeName";

    public RabbitMQ(ConnectionFactory factory, DynamicObject cfg) {
        this.factory = factory;
        String virtualHost = factory.getVirtualHost();
        if (SPECIAL_TAG.equals(virtualHost)) {
            this.cn = RabbitmqFactory.getConnection((String)"mq.server");
        } else {
            try {
                this.cn = factory.newConnection();
            }
            catch (IOException | TimeoutException e) {
                String name = cfg.getString("name");
                String number = cfg.getString("number");
                throw ConnectorError.RABBIT_CONNECT_ERROR.create((Throwable)e, new String[]{name, number, StringUtil.getMessage((Throwable)e)});
            }
        }
        this.cfg = cfg;
    }

    @Override
    public DynamicObject getConfig() {
        return this.cfg;
    }

    @Override
    public long getId() {
        return D.l((Object)this.cfg.getPkValue());
    }

    @Override
    public synchronized void attachListener(String topic, MessageReceiver receiver) {
        if (this.consumers.containsKey(topic)) {
            throw ConnectorError.TOPIC_SUBSCRIBED.create(new String[]{topic});
        }
        try {
            Channel ch = this.innerCreateConsumerChannel(topic, receiver, null);
            this.consumers.put(topic, ch);
        }
        catch (IOException | TimeoutException e) {
            throw this.handleError(e);
        }
    }

    @Override
    public synchronized void attachListener(String topic, MessageReceiver receiver, String customParam) {
        if (this.consumers.containsKey(topic)) {
            throw ConnectorError.TOPIC_SUBSCRIBED.create(new String[]{topic});
        }
        try {
            Channel ch = this.innerCreateConsumerChannel(topic, receiver, customParam);
            this.consumers.put(topic, ch);
        }
        catch (IOException | TimeoutException e) {
            throw this.handleError(e);
        }
    }

    private IscBizException handleError(Throwable e) {
        String name = this.cfg.getString("name");
        String number = this.cfg.getString("number");
        return ConnectorError.RABBIT_CONNECT_ERROR.create(e, new String[]{name, number, e.getMessage()});
    }

    @Override
    public synchronized void detachListeners() {
        Iterator<Map.Entry<String, Channel>> it = this.consumers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Channel> e = it.next();
            it.remove();
            Channel channel = e.getValue();
            try {
                channel.close();
            }
            catch (Throwable err) {
                logger.warn("failed to close channel. channel = " + channel, err);
            }
        }
    }

    @Override
    public void publish(String topic, PublishedMessage msg) {
        Publisher p = this.getPubChannel(topic, null);
        p.send(msg);
    }

    @Override
    public void publish(String topic, PublishedMessage msg, String customParam) {
        Publisher p = this.getPubChannel(topic, customParam);
        p.send(msg);
    }

    private Publisher getPubChannel(String topic, String customParam) {
        Publisher p = this.publishers.get(topic);
        if (p != null) {
            return p;
        }
        return this.createPubChannel(topic, customParam);
    }

    private synchronized Publisher createPubChannel(String topic, String customParam) {
        Publisher p = this.publishers.get(topic);
        if (p == null) {
            p = new Publisher(topic, new ChannelFactory(), customParam);
            this.publishers.put(topic, p);
        }
        return p;
    }

    private Channel innerCreatePublisherChannel(String topic, MessageConfirmListener listener, String customParam) throws IOException, TimeoutException {
        Channel ch = this.preparePubConnection().createChannel();
        this.initPublisherChannel(ch, topic, listener, customParam);
        return ch;
    }

    private Channel innerCreateConsumerChannel(String topic, MessageReceiver receiver, String customParam) throws IOException, TimeoutException {
        Channel ch = this.prepareSubConnection().createChannel();
        this.initConsumerChannel(ch, topic, receiver, customParam);
        return ch;
    }

    private Connection preparePubConnection() throws IOException, TimeoutException {
        if (this.cn == null || !this.cn.isOpen()) {
            this.cn = this.factory.newConnection();
        }
        return this.cn;
    }

    private Connection prepareSubConnection() throws IOException, TimeoutException {
        if (this.cn == null || !this.cn.isOpen()) {
            this.cn = this.factory.newConnection();
        }
        return this.cn;
    }

    private void initPublisherChannel(Channel ch, String topic, MessageConfirmListener listener, String customParam) throws IOException, TimeoutException {
        try {
            Map configMap = (Map)Json.toObject((String)customParam);
            if (!this.existQueue(configMap)) {
                String exchange = this.getExchangeName(configMap);
                String routingKey = this.getRoutingKey(configMap);
                ch.exchangeDeclare(exchange, "direct", true);
                ch.queueDeclare(topic, true, false, false, null);
                ch.queueBind(topic, exchange, routingKey);
            }
            ch.confirmSelect();
            ch.addConfirmListener((ConfirmListener)listener);
        }
        catch (Throwable e) {
            ch.close();
            throw this.handleError(e);
        }
    }

    private void initConsumerChannel(Channel ch, String topic, MessageReceiver receiver, String customParam) throws IOException, TimeoutException {
        try {
            Map configMap = (Map)Json.toObject((String)customParam);
            if (!this.existQueue(configMap)) {
                String exchange = this.getExchangeName(configMap);
                String routingKey = this.getRoutingKey(configMap);
                ch.exchangeDeclare(exchange, "direct", true);
                ch.queueDeclare(topic, true, false, false, null);
                ch.queueBind(topic, exchange, routingKey);
            }
            ch.basicConsume(topic, false, (Consumer)new MessageConsumer(ch, receiver));
        }
        catch (Throwable e) {
            ch.close();
            throw this.handleError(e);
        }
    }

    private boolean existQueue(Map<String, Object> configMap) {
        if (configMap == null) {
            return false;
        }
        return D.x((Object)configMap.get("existQueue"));
    }

    private String getExchangeName(Map<String, Object> configMap) {
        if (configMap == null || StringUtil.isEmpty((String)D.s((Object)configMap.get("exchange")))) {
            return EXCHANGE_NAME;
        }
        return D.s((Object)configMap.get("exchange"));
    }

    private String getRoutingKey(Map<String, Object> configMap) {
        if (configMap == null || StringUtil.isEmpty((String)D.s((Object)configMap.get("routingKey")))) {
            return "routingKey";
        }
        return D.s((Object)configMap.get("routingKey"));
    }

    private static class Publisher {
        private static final int MAX_COUNT = 5;
        private LinkedList<Pair<Channel, MessageConfirmListener>> items = new LinkedList();
        private int count = 0;
        private ChannelFactory factory;
        private String topic;
        private String customParam;

        private Publisher(String topic, ChannelFactory factory, String customParam) {
            this.topic = topic;
            this.factory = factory;
            this.customParam = customParam;
        }

        private synchronized Pair<Channel, MessageConfirmListener> take() {
            while (this.items.isEmpty() && this.count >= 5) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw CommonError.THREAD_INTERRUPTED.wrap((Throwable)e);
                }
            }
            Pair<Channel, MessageConfirmListener> p = this.items.isEmpty() ? this.createChannel() : this.items.removeFirst();
            if (!((Channel)p.getKey()).isOpen()) {
                p = this.createChannel();
            }
            ++this.count;
            return p;
        }

        private synchronized void dispose(Pair<Channel, MessageConfirmListener> p) {
            --this.count;
            this.items.addLast(p);
            this.notifyAll();
        }

        private Pair<Channel, MessageConfirmListener> createChannel() {
            try {
                MessageConfirmListener l = new MessageConfirmListener();
                Channel ch = this.factory.newPubChannel(this.topic, l, this.customParam);
                return new Pair((Object)ch, (Object)l);
            }
            catch (Exception e) {
                throw ConnectorError.MQ_PUBLISH_MESSAGE_FAILURE.wrap((Throwable)e);
            }
        }

        private void send(PublishedMessage msg) {
            Pair<Channel, MessageConfirmListener> p = this.take();
            try {
                this.publish(p, msg);
            }
            finally {
                this.dispose(p);
            }
        }

        private void publish(Pair<Channel, MessageConfirmListener> p, PublishedMessage msg) {
            Channel ch = (Channel)p.getKey();
            MessageConfirmListener l = (MessageConfirmListener)p.getValue();
            long tag = ch.getNextPublishSeqNo();
            l.monitor(tag, msg);
            try {
                ch.basicPublish("", this.topic, null, msg.getData());
                l.commit(tag);
            }
            catch (Throwable e) {
                l.rollback(tag);
                throw ConnectorError.MQ_PUBLISH_MESSAGE_FAILURE.wrap(e);
            }
        }
    }

    private class ChannelFactory {
        private ChannelFactory() {
        }

        Channel newPubChannel(String topic, MessageConfirmListener l, String customParam) throws IOException, TimeoutException {
            return RabbitMQ.this.innerCreatePublisherChannel(topic, l, customParam);
        }
    }
}

