/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.rocketmq;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.mq.MessageReceiver;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;

public class RocketMessageListener
implements MessageListenerConcurrently {
    private static final Log LOG = LogFactory.getLog(RocketMessageListener.class);
    private final MessageReceiver receiver;

    public RocketMessageListener(MessageReceiver receiver) {
        this.receiver = receiver;
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> list, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        for (MessageExt messageExt : list) {
            try {
                this.receiver.handleMessage(messageExt.getBody());
            }
            catch (Exception e) {
                LOG.warn("failed to handle message.", (Throwable)e);
            }
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }
}

