/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.mq.rocketmq;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.mq.PublishedMessage;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;

public class RocketSendCallback
implements SendCallback {
    private static final Log logger = LogFactory.getLog(RocketSendCallback.class);
    private final PublishedMessage msg;

    public RocketSendCallback(PublishedMessage msg) {
        this.msg = msg;
    }

    public void onSuccess(SendResult sendResult) {
        logger.info("send success. id=" + this.msg.getId() + " " + sendResult);
        try {
            this.msg.setSuccess();
        }
        catch (Exception ex) {
            logger.warn("onCompletion setSuccess failed. id=" + this.msg.getId(), (Throwable)ex);
        }
    }

    public void onException(Throwable e) {
        logger.warn("onCompletion failed. id=" + this.msg.getId(), e);
        try {
            this.msg.setFailed(e);
        }
        catch (Exception ex) {
            logger.warn("onCompletion setFailed failed. id=" + this.msg.getId(), (Throwable)ex);
        }
    }
}

