/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dc.s;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorPermissionPusher;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.s.TriggerFinder;
import kd.isc.iscb.platform.core.dc.s.TriggerType;
import kd.isc.iscb.util.bean.BatchTriggerInfo;
import kd.isc.iscb.util.bean.EachTriggerInfo;

public enum InitData {
    Bindings(1){

        @Override
        public Object prepareData(ConnectionWrapper cn) {
            String iscHub = this.getIscHub(cn);
            BatchTriggerInfo batchTriggerInfo = new BatchTriggerInfo(iscHub);
            ArrayList<EachTriggerInfo> triggerInfoList = new ArrayList<EachTriggerInfo>();
            List<Long> associateDblinkIds = this.getDblinkIds(cn);
            for (Long dbLinkId : associateDblinkIds) {
                for (TriggerType triggerType : TriggerType.values()) {
                    TriggerFinder finder = triggerType.getTriggerFinder(dbLinkId);
                    triggerInfoList.addAll(finder.findTriggerList());
                }
            }
            triggerInfoList.sort(Comparator.comparing(a -> String.valueOf(a.getTriggerId())));
            batchTriggerInfo.setTriggers(triggerInfoList);
            return batchTriggerInfo;
        }

        private String getIscHub(ConnectionWrapper cn) {
            if (InitData.isSelf(cn)) {
                return InitData.SELF;
            }
            return ConnectorUtil.getIscHub(cn.getConfig());
        }

        private List<Long> getDblinkIds(ConnectionWrapper cn) {
            DynamicObject cfg = cn.getConfig();
            ArrayList<Long> dblinkIds = new ArrayList<Long>();
            if (InitData.isSelf(cn)) {
                QFilter filter = new QFilter("database_type", "=", (Object)"self");
                DynamicObjectCollection links = QueryServiceHelper.query((String)"isc_database_link", (String)"id,database_type", (QFilter[])new QFilter[]{filter});
                for (DynamicObject link : links) {
                    dblinkIds.add(link.getLong("id"));
                }
                return dblinkIds;
            }
            dblinkIds.add(cfg.getLong("id"));
            return dblinkIds;
        }
    }
    ,
    Autoritys(2){

        @Override
        public Object prepareData(ConnectionWrapper cn) {
            if (InitData.isSelf(cn)) {
                return null;
            }
            return ConnectorPermissionPusher.readPermission(cn);
        }
    }
    ,
    EventLog(4){

        @Override
        public Object prepareData(ConnectionWrapper cn) {
            if (InitData.isSelf(cn)) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("iscHub", ConnectorUtil.getIscHub(cn.getConfig()));
            return map;
        }
    };

    private final int value;
    private static final String SELF = "{self}";

    private static boolean isSelf(ConnectionWrapper cn) {
        DynamicObject cfg = cn.getConfig();
        return "self".equals(cfg.get("database_type"));
    }

    private InitData(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public abstract Object prepareData(ConnectionWrapper var1);
}

