/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.debug;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.debug.ScriptDebugCache;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.debugger.DebuggableResource;
import kd.isc.iscb.util.script.BreakpointManager;

public class PredefinedBreakpointManager
implements BreakpointManager {
    private static final ConcurrentHashMap<String, List<Integer>> breakpoints = new ConcurrentHashMap(1024);
    private static volatile boolean isEmpty = true;

    public void attachBreakpoints(DebuggableResource p) {
        String id = p.getResourceId();
        if (id == null) {
            return;
        }
        if (isEmpty) {
            return;
        }
        List<Integer> list = breakpoints.get(id);
        if (list != null) {
            for (Integer line : list) {
                p.attachBreakpoint(line.intValue());
            }
        }
    }

    public static void registerBreakpoints(Map<String, List<Integer>> breakpoints) {
        String accountId = RequestContext.get().getAccountId();
        for (String resId : breakpoints.keySet()) {
            if (resId.endsWith(accountId)) continue;
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8d44\u6e90ID\u5fc5\u987b\u4ee5\u5f53\u524d\u8d26\u5957ID\u4e3a\u540e\u7f00\u3002", (String)"PredefinedBreakpointManager_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        PredefinedBreakpointManager.mqRegisterBreakpoints(breakpoints);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)PredefinedBreakpointManager.class.getName(), (String)"mqRegisterBreakpoints", (Object[])new Object[]{breakpoints});
    }

    public static void mqRegisterBreakpoints(Map<String, List<Integer>> breakpoints) {
        PredefinedBreakpointManager.breakpoints.putAll(breakpoints);
        isEmpty = false;
    }

    public static void clearBreakpoints() {
        String accountId = RequestContext.get().getAccountId();
        PredefinedBreakpointManager.mqClearBreakpoints(accountId);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)PredefinedBreakpointManager.class.getName(), (String)"mqClearBreakpoints", (Object[])new Object[]{accountId});
    }

    public static void mqClearBreakpoints(String accountId) {
        for (String key : breakpoints.entrySet().toArray(new String[0])) {
            if (key == null || !key.endsWith(accountId)) continue;
            breakpoints.remove(key);
        }
        isEmpty = breakpoints.isEmpty();
    }

    static {
        BreakpointManager.REF.set((Object)new PredefinedBreakpointManager());
        ScheduleManager.submit((Task)new DaemonTask(){
            private final String id = UUID.randomUUID().toString();

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void run() {
                try {
                    if (ScriptDebugCache.getDebuggerCount() == 0) {
                        isEmpty = true;
                        breakpoints.clear();
                    }
                }
                finally {
                    ScheduleManager.submit((Task)this, 10);
                }
            }
        }, 10);
    }
}

