/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.platform.core.debug.ScriptDebugSignal;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.data.Buffer;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.SimpleFC;

public class ScriptDebugCache {
    private static volatile int debuggerCount = 0;
    private static Map<String, Item> debuggers = new ConcurrentHashMap<String, Item>(64);
    private static boolean daemonTaskReady = false;

    public static int getDebuggerCount() {
        return debuggerCount;
    }

    public static boolean isDebugEnabled() {
        if (debuggerCount == 0) {
            return false;
        }
        return debuggers.containsKey(ScriptDebugCache.getKey());
    }

    public static boolean isLogsEnabled() {
        if (debuggerCount == 0) {
            return false;
        }
        Item item = debuggers.get(ScriptDebugCache.getKey());
        if (item == null) {
            return false;
        }
        return !item.logsIgnored;
    }

    public static void enableDebug() {
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqEnableDebug(userId, accountId);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqEnableDebug", (Object[])new Object[]{userId, accountId});
    }

    public static void clearLogs() {
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqClearLogs(userId, accountId);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqClearLogs", (Object[])new Object[]{userId, accountId});
    }

    public static void setLogsIgnored(boolean ignored) {
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqSetLogsIgnored(userId, accountId, ignored);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqSetLogsIgnored", (Object[])new Object[]{userId, accountId, ignored});
    }

    public static void disableDebug() {
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqDisableDebug(userId, accountId);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqDisableDebug", (Object[])new Object[]{userId, accountId});
    }

    static void pushLog(Map<String, Object> log) {
        SimpleFC.visitByKey((String)"SCRIPT_DEBUG_LOG");
        log.put("id", Hash.mur16((Object[])new Object[]{UUID.randomUUID()}));
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqPushLog(userId, accountId, log);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqPushLog", (Object[])new Object[]{userId, accountId, log});
    }

    static void attachBreakpoint(Map<String, Object> log) {
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqAttachBreakpoint(userId, accountId, log);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqAttachBreakpoint", (Object[])new Object[]{userId, accountId, log});
    }

    static void refreshBreakpoints(String breakpointId, List<Map<String, Object>> breakpoints) {
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqRefreshBreakpoints(userId, accountId, breakpointId, breakpoints);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqRefreshBreakpoints", (Object[])new Object[]{userId, accountId, breakpointId, breakpoints});
    }

    public static void mqRefreshBreakpoints(String userId, String accountId, String breakpointId, List<Map<String, Object>> breakpoints) {
        Map log;
        Item item = debuggers.get(accountId);
        if (item != null && (log = (Map)item.breakpoints.get(breakpointId)) != null) {
            log.put("breakpoints", breakpoints);
            item.breakpointsTs = System.currentTimeMillis();
        }
    }

    static void removeBreakpoint(String id) {
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqRemoveBreakpoint(userId, accountId, id);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqRemoveBreakpoint", (Object[])new Object[]{userId, accountId, id});
    }

    static void setExprResult(String id, String expr, String result) {
        RequestContext ctx = RequestContext.get();
        String userId = ctx.getUserId();
        String accountId = ctx.getAccountId();
        ScriptDebugCache.mqSetExprResult(userId, accountId, id, expr, result);
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)ScriptDebugCache.class.getName(), (String)"mqSetExprResult", (Object[])new Object[]{userId, accountId, id, expr, result});
    }

    public static String getExprResult(String id, String expr) {
        RequestContext ctx = RequestContext.get();
        Item item = debuggers.get(ctx.getAccountId());
        if (item == null) {
            return null;
        }
        if (Objects.equals(id, item.breakpoint) && Objects.equals(expr, item.expr)) {
            return item.result;
        }
        return null;
    }

    public static Map<String, Object> getBreakpointInfo(String id) {
        RequestContext ctx = RequestContext.get();
        Item item = debuggers.get(ctx.getAccountId());
        if (item != null) {
            return (Map)item.breakpoints.get(id);
        }
        return null;
    }

    public static void mqSetExprResult(String userId, String accountId, String id, String expr, String result) {
        Item item = debuggers.get(accountId);
        if (item != null && item.breakpoints.containsKey(id)) {
            item.breakpoint = id;
            item.expr = expr;
            item.result = result;
            item.breakpointsTs = System.currentTimeMillis();
        }
    }

    public static void mqRemoveBreakpoint(String userId, String accountId, String id) {
        Item item = debuggers.get(accountId);
        if (item != null) {
            item.breakpoints.remove(id);
            item.breakpointsTs = System.currentTimeMillis();
        }
    }

    public static Collection<Map<String, Object>> getBreakpoints(long ts) {
        Item item = debuggers.get(ScriptDebugCache.getKey());
        if (item == null) {
            return Collections.emptyList();
        }
        if (item.breakpointsTs <= ts) {
            return null;
        }
        ArrayList<Map<String, Object>> logs = new ArrayList<Map<String, Object>>();
        for (Map log : item.breakpoints.values()) {
            logs.add(log);
        }
        Collections.sort(logs, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> a, Map<String, Object> b) {
                String s1 = (String)a.get("time");
                String s2 = (String)b.get("time");
                return -s1.compareTo(s2);
            }
        });
        return logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Map<String, Object>> getDebugLogs(long logsTs) {
        Item item = debuggers.get(ScriptDebugCache.getKey());
        if (item == null) {
            return Collections.emptyList();
        }
        if (item.logsTs <= logsTs) {
            return null;
        }
        Buffer buffer = item.logs;
        synchronized (buffer) {
            LinkedList<Map<String, Object>> logs = new LinkedList<Map<String, Object>>();
            for (Map log : item.logs) {
                logs.addFirst(log);
            }
            return logs;
        }
    }

    public static void mqDisableDebug(String userId, String accountId) {
        Item item = debuggers.get(accountId);
        if (item != null && item.user.equals(userId)) {
            ScriptDebugCache.resumeBreakpoints(item);
            debuggers.remove(accountId);
            debuggerCount = debuggers.size();
        }
    }

    public static void mqSetLogsIgnored(String userId, String accountId, boolean ignored) {
        Item item = debuggers.get(accountId);
        if (item != null) {
            item.logsIgnored = ignored;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mqPushLog(String userId, String accountId, Map<String, Object> log) {
        Item item = debuggers.get(accountId);
        if (item != null) {
            Buffer buffer = item.logs;
            synchronized (buffer) {
                Map last = (Map)item.logs.last();
                if (last == null) {
                    item.logs.add(log);
                } else if (!Objects.equals(last.get("id"), log.get("id"))) {
                    item.logs.add(log);
                }
            }
            item.logsTs = System.currentTimeMillis();
        }
    }

    public static void mqAttachBreakpoint(String userId, String accountId, Map<String, Object> log) {
        Item item = debuggers.get(accountId);
        if (item != null) {
            item.breakpoints.put((String)log.get("id"), log);
            item.breakpointsTs = System.currentTimeMillis();
        }
    }

    public static void mqEnableDebug(String userId, String accountId) {
        Item item = debuggers.get(accountId);
        if (item == null) {
            debuggers.put(accountId, new Item(userId));
            debuggerCount = debuggers.size();
        } else {
            item.lastAccessTime = System.currentTimeMillis();
        }
        SimpleFC.setMaxTpsByKey((String)"SCRIPT_DEBUG_LOG", (int)5);
        ScriptDebugCache.submitDaemonTask();
    }

    public static String getDebugUser() {
        Item item = debuggers.get(ScriptDebugCache.getKey());
        if (item == null) {
            return null;
        }
        return D.s((Object)ProxyUserUtil.get(item.user).get("name"));
    }

    public static String getDebugUserId() {
        Item item = debuggers.get(ScriptDebugCache.getKey());
        if (item == null) {
            return null;
        }
        return item.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mqClearLogs(String userId, String accountId) {
        Item item = debuggers.get(accountId);
        if (item != null) {
            Buffer buffer = item.logs;
            synchronized (buffer) {
                item.logs.clear();
            }
            item.logsTs = System.currentTimeMillis();
        }
    }

    private static String getKey() {
        RequestContext ctx = RequestContext.get();
        return ctx.getAccountId();
    }

    private static synchronized void submitDaemonTask() {
        if (daemonTaskReady) {
            return;
        }
        if (ScriptDebugCache.requestContextIsEmpty()) {
            ScriptDebugCache.setFakeContext();
        }
        ScriptDebugCache.innerSubmitDaemonTask();
        daemonTaskReady = true;
    }

    private static boolean requestContextIsEmpty() {
        RequestContext ctx = RequestContext.get();
        return ctx == null || D.s((Object)ctx.getTenantId()) == null;
    }

    private static void setFakeContext() {
        RequestContext ctx = ContextUtil.createRequestContext("fake_account", "fake_tenant");
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
    }

    private static void innerSubmitDaemonTask() {
        ScheduleManager.submit((Task)new DaemonTask(){

            @Override
            public String getId() {
                return ScriptDebugCache.class.getName();
            }

            @Override
            public void run() {
                try {
                    this.removeTimeoutDebuggers();
                    debuggerCount = debuggers.size();
                }
                catch (Throwable err) {
                    Log log = LogFactory.getLog(ScriptDebugCache.class);
                    log.warn("\u6e05\u7406\u8fc7\u671f\u8c03\u8bd5\u8005\u5931\u8d25", err);
                }
                finally {
                    ScheduleManager.submit((Task)this, 5);
                }
            }

            private void removeTimeoutDebuggers() {
                long deadline = System.currentTimeMillis() - 10000L;
                Iterator it = debuggers.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    if (((Item)e.getValue()).lastAccessTime >= deadline) continue;
                    it.remove();
                    ScriptDebugCache.resumeBreakpoints((Item)e.getValue());
                }
            }
        }, 5);
    }

    private static void resumeBreakpoints(Item item) {
        for (Object id : ((ConcurrentHashMap.CollectionView)((Object)item.breakpoints.keySet())).toArray()) {
            ScriptDebugSignal.resume((String)id);
        }
    }

    private static class Item {
        private final String user;
        private volatile long lastAccessTime = System.currentTimeMillis();
        private volatile long logsTs = System.currentTimeMillis();
        private volatile long breakpointsTs = System.currentTimeMillis();
        private volatile boolean logsIgnored = false;
        private volatile String expr;
        private volatile String result;
        private volatile String breakpoint;
        private final Buffer<Map<String, Object>> logs = new Buffer(64);
        private final ConcurrentHashMap<String, Map<String, Object>> breakpoints = new ConcurrentHashMap(64);

        Item(String user) {
            this.user = user;
        }
    }
}

