/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ischub.EventSrcUtil;
import kd.isc.iscb.platform.core.dts.EntityAndFieldsFilter;
import kd.isc.iscb.platform.core.dts.handler.DataCopyPreHandler;
import kd.isc.iscb.platform.core.dts.handler.PreHandler;
import kd.isc.iscb.platform.core.dts.handler.PreHandlerFactory;
import kd.isc.iscb.platform.core.dts.handler.export.ExportHandlerFactory;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class ExportDynamicObject {
    public static void export(OutputStream out, DynamicObject ... objects) throws IOException {
        ExportDynamicObject.export(out, objects, true);
    }

    public static void export(OutputStream out, DynamicObject[] objects, boolean exportDependencies) throws IOException {
        List<DynamicObject> list = exportDependencies ? ExportDynamicObject.loadObjectsAndDependencies(objects) : Arrays.asList(objects);
        for (DynamicObject o : list) {
            Map<String, Object> map = ExportDynamicObject.object2map(o);
            map.put("$id", o.getPkValue());
            map.put("$entityname", o.getDataEntityType().getName());
            map.put("$isref", !ExportDynamicObject.exists(o, objects));
            String s = Json.toString(map);
            out.write(s.getBytes(StandardCharsets.UTF_8));
            out.write(10);
        }
    }

    public static List<DynamicObject> loadObjectsAndDependencies(DynamicObject[] objects) {
        Graph g = new Graph();
        for (DynamicObject o : objects) {
            ExportDynamicObject.append((Graph<DynamicObject>)g, o);
        }
        List list = g.topSort();
        if (list.size() != g.getNodeCount()) {
            Map<String, List<String>> bills = ExportDynamicObject.getCrossRefs((Graph<DynamicObject>)g, list);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e4b\u95f4\u5b58\u5728\u5faa\u73af\u5f15\u7528\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u51fa\uff01\u6d89\u53ca\u7684\u5355\u636e\u6709\uff1a%s", (String)"ExportDynamicObject_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), bills));
        }
        return list;
    }

    public static Map<String, List<String>> getCrossRefs(Graph<DynamicObject> g, List<DynamicObject> list) {
        Set nodes = g.getNodes();
        nodes.removeAll(list);
        HashMap<String, List<String>> bills = new HashMap<String, List<String>>();
        for (DynamicObject o : nodes) {
            String type = D.s((Object)o.getDataEntityType().getDisplayName());
            List numbers = bills.computeIfAbsent(type, k -> new ArrayList());
            numbers.add(D.s((Object)o.get("number")));
        }
        return bills;
    }

    public static boolean exists(DynamicObject d, DynamicObject ... objects) {
        for (DynamicObject tmp : objects) {
            if (!tmp.getPkValue().equals(d.getPkValue()) || !tmp.getDataEntityType().getName().equals(d.getDataEntityType().getName())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> object2map(DynamicObject o) {
        String entityName = o.getDataEntityType().getName();
        Map<String, Object> requires = ExportDynamicObject.prepareRequires(entityName);
        Map<String, Object> data = DynamicObjectUtil.object2Map(o, requires);
        Map<String, Object> result = ExportDynamicObject.excludeFields(entityName, data);
        return result;
    }

    private static Map<String, Object> prepareRequires(String entityName) {
        if (EntityAndFieldsFilter.isRetainEntity(entityName)) {
            Set<String> set = EntityAndFieldsFilter.getRetainMap().get(entityName);
            HashMap<String, Object> requires = new HashMap<String, Object>(set.size());
            for (String field : set) {
                requires.put(field, "1");
            }
            requires.put("id", "1");
            return requires;
        }
        return Collections.emptyMap();
    }

    private static Map<String, Object> excludeFields(String entityName, Map<String, Object> data) {
        Map<String, Set<String>> map = EntityAndFieldsFilter.getIgnoredMap();
        HashMap<String, Object> result = new HashMap<String, Object>(data);
        ExportDynamicObject.removeIgnoreFields(map.get("*"), result);
        ExportDynamicObject.removeIgnoreFields(map.get(entityName), result);
        return result;
    }

    private static void removeIgnoreFields(Set<String> fields, Map<String, Object> data) {
        if (fields != null) {
            for (String field : fields) {
                data.remove(field);
            }
        }
    }

    public static void append(Graph<DynamicObject> g, DynamicObject o) {
        boolean added = ExportDynamicObject.appendNode(g, o);
        if (added) {
            ExportDynamicObject.appendIndirectRef(g, o);
            ExportDynamicObject.appendReference(g, o);
        }
    }

    private static void appendIndirectRef(Graph<DynamicObject> g, DynamicObject o) {
        String entityName = o.getDynamicObjectType().getName();
        List<DynamicObject> inDirectRefs = ExportHandlerFactory.getHandler(entityName).getInDirectRefs(o);
        if (!CollectionUtils.isEmpty(inDirectRefs)) {
            String to = ExportDynamicObject.getKey(o);
            for (DynamicObject ref : inDirectRefs) {
                ExportDynamicObject.appendReference(g, to, ref);
            }
        }
    }

    private static boolean appendNode(Graph<DynamicObject> g, DynamicObject o) {
        String key = ExportDynamicObject.getKey(o);
        if (g.contains(key)) {
            return false;
        }
        g.appendVertex(key, (Object)o);
        return true;
    }

    private static void appendReference(Graph<DynamicObject> g, DynamicObject o) {
        String to = ExportDynamicObject.getKey(o);
        DataEntityPropertyCollection collection = o.getDataEntityType().getProperties();
        String entityName = o.getDynamicObjectType().getName();
        Set<String> excludedFields = ExportHandlerFactory.getHandler(entityName).getExcludedFields();
        for (IDataEntityProperty prop : collection) {
            String name = prop.getName();
            Object value = o.get(prop);
            if (EntityAndFieldsFilter.isIgnoredField(entityName, name) || excludedFields.contains(name)) continue;
            if (value instanceof DynamicObject) {
                DynamicObject old = (DynamicObject)value;
                DynamicObject newObj = BusinessDataServiceHelper.loadSingle((Object)old.getPkValue(), (String)old.getDynamicObjectType().getName());
                ExportDynamicObject.appendReference(g, to, newObj);
                continue;
            }
            if (value instanceof DynamicObjectCollection) {
                String parentEntityName = to.split(",")[0];
                if ("isc_data_copy".equals(parentEntityName)) {
                    ExportDynamicObject.appendDcReferenceFromEntries(g, to, (DynamicObjectCollection)value);
                }
                ExportDynamicObject.appendReferenceFromEntries(g, to, (DynamicObjectCollection)value);
                continue;
            }
            if (!"isc_metadata_schema".equals(entityName) || !"EVT_RSC".equals(o.getString("type"))) continue;
            String fullName = o.getString("full_name");
            DynamicObject eventSrcObject = EventSrcUtil.retrieveEventSrcObject(fullName);
            ExportDynamicObject.appendReference(g, to, eventSrcObject);
        }
    }

    private static void appendReferenceFromEntries(Graph<DynamicObject> g, String to, DynamicObjectCollection entries) {
        DynamicObjectType entryType = entries.getDynamicObjectType();
        String entityName = entryType.getName();
        Set<String> excludedFields = ExportHandlerFactory.getHandler(entryType.getParent().getName()).getExcludedFields();
        for (DynamicObject e : entries) {
            DataEntityPropertyCollection collection = e.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : collection) {
                String name = prop.getName();
                Object value = e.get(prop);
                if (EntityAndFieldsFilter.isIgnoredField(entityName, name) || excludedFields.contains(entityName + "." + prop.getName())) continue;
                if (value != null && !StringUtil.isEmpty((String)value.toString()) && EntityAndFieldsFilter.isIndirectRef(to, entityName, name)) {
                    ExportDynamicObject.appendIndirectReference(g, to, e, name);
                    continue;
                }
                if (!(value instanceof DynamicObject)) continue;
                DynamicObject old = (DynamicObject)value;
                DynamicObject newObj = BusinessDataServiceHelper.loadSingle((Object)old.getPkValue(), (String)old.getDynamicObjectType().getName());
                ExportDynamicObject.appendReference(g, to, newObj);
            }
        }
    }

    private static void appendDcReferenceFromEntries(Graph<DynamicObject> g, String to, DynamicObjectCollection entries) {
        List<DynamicObject> refs;
        if (entries.isEmpty()) {
            return;
        }
        String entityType = ((DynamicObject)entries.get(0)).getDataEntityType().getName();
        if (("mapping_entries".equals(entityType) || "filter_entries".equals(entityType) || "sort_entries".equals(entityType)) && !(refs = DataCopyPreHandler.getIndirectRef(to, entries, entityType)).isEmpty()) {
            for (DynamicObject ref : refs) {
                ExportDynamicObject.appendReference(g, to, ref);
            }
        }
    }

    private static void appendIndirectReference(Graph<DynamicObject> g, String to, DynamicObject o, String field) {
        DynamicObject ref;
        String[] split = to.split(",");
        String entityName = split[0];
        PreHandler preHandler = PreHandlerFactory.get(entityName);
        if (preHandler != null && (ref = preHandler.getIndirectRef(to, o)) != null) {
            ExportDynamicObject.appendReference(g, to, ref);
        }
    }

    private static void appendReference(Graph<DynamicObject> g, String to, DynamicObject ref) {
        String from;
        if (EntityAndFieldsFilter.isIgnoredRef(ref)) {
            return;
        }
        if (EntityAndFieldsFilter.isReplaceRef(ref)) {
            Object pk = ref.getPkValue();
            String replaceEntity = EntityAndFieldsFilter.getReplaceRefMap().get(ref.getDynamicObjectType().getName());
            ref = BusinessDataServiceHelper.loadSingle((Object)pk, (String)replaceEntity);
        }
        if (g.contains(from = ExportDynamicObject.getKey(ref), to)) {
            return;
        }
        ExportDynamicObject.append(g, ref);
        g.append(from, to);
    }

    private static String getKey(DynamicObject o) {
        String entity = o.getDataEntityType().getName();
        String pk = o.getPkValue().toString();
        return entity + "," + pk;
    }
}

