/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.UserProp;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.dts.EntityAndFieldsFilter;
import kd.isc.iscb.platform.core.dts.IllegalImportException;
import kd.isc.iscb.platform.core.dts.handler.AfterSaveHandler;
import kd.isc.iscb.platform.core.dts.handler.AfterSaveHandlerFactory;
import kd.isc.iscb.platform.core.dts.handler.PostHandler;
import kd.isc.iscb.platform.core.dts.handler.PostHandlerFactory;
import kd.isc.iscb.platform.core.dts.handler.PreHandler;
import kd.isc.iscb.platform.core.dts.handler.PreHandlerFactory;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class ImportDynamicObject {
    public static void asyncImportSchemas(String pageId, List<String> urlList, String entity) {
        PageCache pageCache = pageId == null ? null : new PageCache(pageId);
        int total = urlList.size();
        for (int i = 0; i < total; ++i) {
            String url = urlList.get(i);
            try {
                ImportDynamicObject.importSchema(i, url, entity);
                ExportAndImportFormUtil.refreshProgress(pageCache, total, i, null);
                continue;
            }
            catch (Exception e) {
                ExportAndImportFormUtil.refreshProgress(pageCache, total, total - 1, e);
            }
        }
    }

    public static void importSchemas(List<String> urlList, String entity) throws IllegalImportException {
        for (int i = 0; i < urlList.size(); ++i) {
            String url = urlList.get(i);
            ImportDynamicObject.importSchema(i, url, entity);
        }
    }

    public static void importSchema(Map<String, Object> attach, String entity) throws IllegalImportException {
        String name = D.s((Object)attach.get("name"));
        String url = D.s((Object)attach.get("url"));
        try {
            List<String> dts = ImportDynamicObject.downloadStrFromCache(url);
            if (dts.isEmpty() || StringUtil.isEmpty((String)entity)) {
                return;
            }
            Map dtMap = (Map)Json.toObject((String)dts.get(dts.size() - 1));
            String realEntity = dtMap.get("$entityname").toString();
            boolean isref = D.x(dtMap.get("$isref"));
            if (!isref && !realEntity.equals(entity)) {
                String requireName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().getLocaleValue();
                String realName = EntityMetadataCache.getDataEntityType((String)realEntity).getDisplayName().getLocaleValue();
                throw new IllegalImportException(String.format(ResManager.loadKDString((String)"\u8be5\u754c\u9762\u53ea\u80fd\u5bfc\u5165'%1$s'\uff0c\u65b9\u6848[%2$s]\u662f'%3$s'\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ImportDynamicObject_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), requireName, name, realName));
            }
            ImportDynamicObject.innerImport(dts);
        }
        catch (IOException e1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4eceredis\u7f13\u5b58%s\u4e2d\u4e0b\u8f7d\u5931\u8d25\uff0c\u65e0\u6cd5\u5bfc\u5165\uff01", (String)"ImportDynamicObject_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), url));
        }
    }

    private static void importSchema(int i, String url, String entity) throws IllegalImportException {
        List<String> dts;
        try {
            dts = ImportDynamicObject.downloadStrFromCache(url);
            ImportDynamicObject.validateDts(i, dts, entity);
        }
        catch (IOException e1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4eceredis\u7f13\u5b58%s\u4e2d\u4e0b\u8f7d\u5931\u8d25\uff0c\u65e0\u6cd5\u5bfc\u5165\uff01", (String)"ImportDynamicObject_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), url));
        }
        ImportDynamicObject.innerImport(dts);
    }

    private static void validateDts(int i, List<String> dts, String requireEntity) throws IllegalImportException {
        if (dts.isEmpty() || StringUtil.isEmpty((String)requireEntity)) {
            return;
        }
        Map dtMap = (Map)Json.toObject((String)dts.get(dts.size() - 1));
        String realEntity = dtMap.get("$entityname").toString();
        boolean isref = D.x(dtMap.get("$isref"));
        if (!isref && !realEntity.equals(requireEntity)) {
            String requireName = EntityMetadataCache.getDataEntityType((String)requireEntity).getDisplayName().getLocaleValue();
            String realName = EntityMetadataCache.getDataEntityType((String)realEntity).getDisplayName().getLocaleValue();
            throw new IllegalImportException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u65b9\u6848\u5e94\u5bfc\u5165\u7684\u662f%2$s(%3$s)\uff0c\u5b9e\u9645\u5bfc\u5165\u7684\u662f%4$s(%5$s)", (String)"ImportDynamicObject_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), i + 1, requireEntity, requireName, realEntity, realName));
        }
    }

    public static void innerImport(InputStream dtsFileInputStream) {
        String dtsFileContent = NetUtil.readText((InputStream)dtsFileInputStream);
        ImportDynamicObject.innerImport(dtsFileContent);
    }

    public static void innerImport(String dtsFileContent) {
        List<String> dts = ImportDynamicObject.toList(dtsFileContent);
        ImportDynamicObject.innerImport(dts);
    }

    public static void innerImport(String dtsFileContent, boolean override) {
        if (!override) {
            ImportDynamicObject.innerImport(dtsFileContent);
        } else {
            List<String> dts = ImportDynamicObject.toList(dtsFileContent);
            for (String dt : dts) {
                Map dtMap = (Map)Json.toObject((String)dt);
                dtMap.put("$isref", Boolean.FALSE);
                ImportDynamicObject.executeImport(dtMap);
            }
        }
    }

    public static List<String> toList(String s) {
        int i = 0;
        int j = s.indexOf(10);
        ArrayList<String> dts = new ArrayList<String>(16);
        while (j > 0) {
            ImportDynamicObject.appendDynamicObject(dts, s, i, j);
            i = j + 1;
            j = s.indexOf(10, i + 1);
        }
        ImportDynamicObject.appendDynamicObject(dts, s, i, s.length());
        return dts;
    }

    private static void appendDynamicObject(ArrayList<String> dts, String s, int i, int j) {
        String o = D.s((Object)s.substring(i, j));
        if (o != null) {
            dts.add(o);
        }
    }

    public static void innerImport(List<String> dts) {
        for (String dt : dts) {
            Map dtMap = (Map)Json.toObject((String)dt);
            ImportDynamicObject.executeImport(dtMap);
        }
    }

    public static void executeImport(Map<String, Object> dtMap) {
        Object id = dtMap.get("$id");
        String entityName = dtMap.get("$entityname").toString();
        boolean isref = (Boolean)dtMap.get("$isref");
        boolean existed = DynamicObjectUtil.inDb(id, entityName);
        if (isref && existed) {
            return;
        }
        try {
            MainEntityType entityType = ImportDynamicObject.preHandle(entityName, id, dtMap, existed);
            ImportDynamicObject.removeCreatorAndModifier((EntityType)entityType, dtMap);
            DynamicObject object = DynamicObjectUtil.map2Object(entityName, dtMap);
            if (EntityAndFieldsFilter.isRetainEntity(entityName)) {
                ImportDynamicObject.setDefaultValues(object, entityName);
            }
            ImportDynamicObject.postHandle(object);
            ImportDynamicObject.restoreCreatorAndModifier(object, isref, id);
            ImportDynamicObject.executeSave(object);
            ImportDynamicObject.afterSaveHandle(object);
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u5bfc\u5165%1$s\u51fa\u9519\uff0c\u539f\u56e0\u662f\uff1a%2$s", (String)"ImportDynamicObject_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), CommonUtil.getEntityName(entityName), StringUtil.getCascadeMessage((Throwable)e));
            throw new IscBizException(message, (Throwable)e);
        }
    }

    private static void afterSaveHandle(DynamicObject object) {
        String entityName = object.getDataEntityType().getName();
        AfterSaveHandler afterSaveHandler = AfterSaveHandlerFactory.get(entityName);
        if (afterSaveHandler != null) {
            afterSaveHandler.handle(object);
        }
    }

    private static MainEntityType preHandle(String entityName, Object id, Map<String, Object> dtMap, boolean existed) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        PreHandler preHandler = PreHandlerFactory.get(entityName);
        if (preHandler != null) {
            preHandler.handle(dtMap, (EntityType)entityType);
            if (existed) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
                preHandler.handle(object);
            }
        }
        return entityType;
    }

    private static void removeCreatorAndModifier(EntityType entityType, Map<String, Object> data) {
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (!(property instanceof UserProp)) continue;
            data.remove(property.getName());
            data.remove(((UserProp)property).getRefIdPropName());
        }
    }

    private static void postHandle(DynamicObject o) {
        if (o != null) {
            String entityName = o.getDataEntityType().getName();
            Map<String, String> handlers = PostHandlerFactory.getHandlers();
            String type = handlers.get(entityName);
            if (type != null) {
                PostHandler postHandler = (PostHandler)TypesContainer.getOrRegisterSingletonInstance((String)type);
                postHandler.handle(o);
            }
        }
    }

    public static void setDefaultValues(DynamicObject object, String entityName) {
        Set<String> retainFields = EntityAndFieldsFilter.getRetainMap().get(entityName);
        DataEntityPropertyCollection propeties = object.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propeties) {
            String field = property.getName();
            if ("id".equals(field) || "multilanguagetext".equals(field) || retainFields.contains(field) || property instanceof DateTimeProp) continue;
            if (property instanceof BasedataProp || property instanceof EntryProp || property instanceof MulBasedataProp) {
                object.set(field, (Object)0);
                continue;
            }
            if (property instanceof BooleanProp) {
                object.set(field, (Object)Boolean.FALSE);
                continue;
            }
            if (property instanceof DecimalProp || property instanceof LongProp) {
                object.set(field, (Object)0);
                continue;
            }
            object.set(field, (Object)" ");
        }
    }

    private static void executeSave(DynamicObject object) {
        if (object != null) {
            String entityName = object.getDataEntityType().getName();
            OperateOption option = ImportDynamicObject.getOption();
            option.setVariableValue("ISHASRIGHT", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])new DynamicObject[]{object}, (OperateOption)option);
            CommonUtil.check(result);
        }
    }

    public static OperateOption getOption() {
        OperateOption option = OperateOption.create();
        if ("1".equals(RequestContext.get().getUserId())) {
            option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            option.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
            option.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(Boolean.TRUE));
        }
        return option;
    }

    private static void restoreCreatorAndModifier(DynamicObject o, boolean isRef, Object id) {
        DataEntityPropertyCollection collection = o.getDataEntityType().getProperties();
        if (!DynamicObjectUtil.inDb(id, o.getDynamicObjectType().getName())) {
            ImportDynamicObject.setCreator(o, collection);
        } else if (!isRef) {
            ImportDynamicObject.setModifier(o, collection);
        }
    }

    private static void setModifier(DynamicObject o, DataEntityPropertyCollection collection) {
        for (IDataEntityProperty property : collection) {
            if (property instanceof ModifierProp) {
                o.set(property.getName(), (Object)RequestContext.get().getUserId());
            }
            if (!(property instanceof ModifyDateProp)) continue;
            o.set(property.getName(), (Object)Timestamp.valueOf(LocalDateTime.now()));
        }
    }

    private static void setCreator(DynamicObject o, DataEntityPropertyCollection collection) {
        for (IDataEntityProperty property : collection) {
            if (property instanceof CreaterProp) {
                o.set(property.getName(), (Object)RequestContext.get().getUserId());
            }
            if (!(property instanceof CreateDateProp)) continue;
            o.set(property.getName(), (Object)Timestamp.valueOf(LocalDateTime.now()));
        }
    }

    public static List<String> downloadStrFromCache(String cacheUrl) throws IOException {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(cacheUrl).getQuery().split("&");
        HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        ArrayList<String> dts = new ArrayList<String>();
        try (BufferedInputStream in = new BufferedInputStream(content.getInputStream());){
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
            int temp = ((InputStream)in).read();
            while (temp >= 0) {
                if (temp != 10) {
                    buffer.write(temp);
                } else {
                    dts.add(new String(buffer.toByteArray(), StandardCharsets.UTF_8));
                    buffer = new ByteArrayOutputStream(2048);
                }
                temp = ((InputStream)in).read();
            }
        }
        return dts;
    }
}

