/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts.handler.export;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dts.handler.export.ExportHandler;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.ReflectionUtil;

public class ExportHandlerFactory {
    private static Map<String, ExportHandler> handlerMap = new HashMap<String, ExportHandler>();

    private static void initHandlerMap() throws IOException {
        InputStream in = ExportHandlerFactory.class.getClassLoader().getResourceAsStream("iscb/dts/export/export_handler.properties");
        try {
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                ExportHandlerFactory.registerExportHandlers(properties);
            }
        }
        finally {
            DbUtil.close((InputStream)in);
        }
    }

    private static void registerExportHandlers(Properties properties) {
        for (Object value : properties.values()) {
            String className = D.s((Object)value);
            if (className == null) continue;
            try {
                ExportHandler handler = (ExportHandler)ReflectionUtil.newInstance((String)className);
                handlerMap.put(handler.getEntityName(), handler);
            }
            catch (Throwable e) {
                LogFactory.getLog(ExportHandlerFactory.class).warn("initialize export handler class error \uff1a" + className, e);
            }
        }
    }

    public static ExportHandler getHandler(String entityName) {
        ExportHandler exportHandler = handlerMap.get(entityName);
        return exportHandler != null ? exportHandler : new DefaultHandler(entityName);
    }

    private static void clear() {
        handlerMap.clear();
    }

    static {
        try {
            ExportHandlerFactory.initHandlerMap();
        }
        catch (Throwable e) {
            LogFactory.getLog(ExportHandlerFactory.class).warn("init export hanlders error :", e);
        }
    }

    static final class DefaultHandler
    implements ExportHandler {
        private String entityName;

        public DefaultHandler(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public String getEntityName() {
            return this.entityName;
        }

        @Override
        public List<DynamicObject> getInDirectRefs(DynamicObject o) {
            return null;
        }
    }
}

