/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts.task;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.dt.D;

public class IscExportTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        TaskInfo taskInfo = this.queryTask();
        IFormView mainView = this.getMainView();
        if (taskInfo.isTaskEnd()) {
            this.showMessageByStatus(e, taskInfo, mainView);
        } else {
            this.showProgressForm(mainView);
        }
    }

    private void showMessageByStatus(ClickEventArgs e, TaskInfo taskInfo, IFormView mainView) {
        String status = taskInfo.getStatus();
        if (status.equals("FAILED")) {
            String failureReason = taskInfo.getFailureReason();
            this.getMainView().showErrMessage(failureReason, null);
        } else if (status.equals("ABORTED")) {
            this.getMainView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6b64\u4efb\u52a1\u5df2\u53d6\u6d88\uff0c\u539f\u56e0\uff1a%s", (String)"IscExportTaskClick_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), taskInfo.getStatusDesc()));
        } else if (status.equals("COMPLETED")) {
            this.openUrl(e, taskInfo, mainView);
        }
    }

    private void openUrl(ClickEventArgs e, TaskInfo taskInfo, IFormView mainView) {
        String data = taskInfo.getData();
        Map customData = (Map)JSON.parse((String)data);
        String url = D.s(customData.get("url"));
        FileUtil.addDownloadPermission(mainView.getEntityId(), url, mainView.getFormShowParameter().getServiceAppId());
        mainView.openUrl(url);
        e.setClearTask(true);
    }

    public boolean release() {
        TaskInfo taskInfo = this.queryTask();
        return taskInfo.isTaskEnd();
    }

    private void showProgressForm(IFormView view) {
        if (this.isExistProgressForm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sch_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isBlank((String)this.getJobFormInfo().getCaption())) {
            showParameter.setCaption(this.getJobFormInfo().getCaption());
        }
        showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
        showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
        view.showForm(showParameter);
        this.getMainView().sendFormAction(view);
        this.setProgressPageId(showParameter.getPageId());
    }
}

