/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.fn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.core.NativeFunction;

public class ScriptFunction
implements NativeFunction {
    private String number;
    private Script script;
    private List<Pair<String, DataType>> inputs;
    private List<Pair<String, DataType>> outputs;

    public ScriptFunction(String number, Script script, List<Pair<String, DataType>> inputs, List<Pair<String, DataType>> outputs) {
        this.number = number;
        this.script = script;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public String name() {
        return this.number;
    }

    public Script getScript() {
        return this.script;
    }

    public List<Pair<String, DataType>> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    public List<Pair<String, DataType>> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    public Map<String, Object> execute(Map<String, Object> args) {
        Map<String, Object> ctx = this.prepareContext(args);
        this.script.eval(ctx);
        return this.generateResultMap(ctx);
    }

    public Object call(ScriptContext sctx, Object[] args) {
        this.checkArgs(args);
        try {
            Map<String, Object> ctx = this.prepareContext(args);
            this.script.eval(ctx);
            return this.generateResult(ctx);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u51fd\u6570\uff08%1$s\uff09\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s", (String)"ScriptFunction_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.number, e.getMessage()), (Throwable)e);
        }
    }

    private Object generateResult(Map<String, Object> ctx) {
        switch (this.outputs.size()) {
            case 1: {
                return this.getSingleResult(ctx);
            }
            case 0: {
                return null;
            }
        }
        return this.getMultiResult(ctx);
    }

    private Object getMultiResult(Map<String, Object> ctx) {
        ArrayList<Object> result = new ArrayList<Object>(this.outputs.size());
        for (Pair<String, DataType> p : this.outputs) {
            Object value = ((DataType)p.getValue()).narrow(ctx.get(p.getKey()));
            result.add(value);
        }
        return result;
    }

    private Object getSingleResult(Map<String, Object> ctx) {
        Pair<String, DataType> p = this.outputs.get(0);
        return ((DataType)p.getValue()).narrow(ctx.get(p.getKey()));
    }

    private Map<String, Object> prepareContext(Object[] args) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.inputs.size() + this.outputs.size());
        for (Pair<String, DataType> p : this.outputs) {
            ctx.put((String)p.getKey(), null);
        }
        for (int i = 0; i < args.length; ++i) {
            Pair<String, DataType> p;
            p = this.inputs.get(i);
            Object value = ((DataType)p.getValue()).narrow(args[i]);
            ctx.put((String)p.getKey(), value);
        }
        return ctx;
    }

    private Map<String, Object> prepareContext(Map<String, Object> args) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.inputs.size() + this.outputs.size());
        for (Pair<String, DataType> p : this.outputs) {
            ctx.put((String)p.getKey(), null);
        }
        for (Pair<String, DataType> p : this.inputs) {
            String key = (String)p.getKey();
            Object value = ((DataType)p.getValue()).narrow(args.get(key));
            ctx.put(key, value);
        }
        return ctx;
    }

    private Map<String, Object> generateResultMap(Map<String, Object> ctx) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.outputs.size());
        for (Pair<String, DataType> p : this.outputs) {
            String key = (String)p.getKey();
            Object value = ((DataType)p.getValue()).narrow(ctx.get(key));
            result.put(key, value);
        }
        return result;
    }

    private void checkArgs(Object[] args) {
        if (args.length != this.inputs.size()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u51fd\u6570\uff08%1$s\uff09\u8981\u6c42%2$s\u4e2a\u53c2\u6570\u503c\uff0c\u5b9e\u9645\u63d0\u4f9b\u7684\u662f%3$s\u4e2a\u3002", (String)"ScriptFunction_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.number, this.inputs.size(), args.length));
        }
    }
}

