/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.fn.ext.http;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.platform.core.api.webapi.multipart.MultipartBody;
import kd.isc.iscb.platform.core.connector.webapi.HttpConnectionWrapper;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.HttpConnectionDecorator;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.misc.HttpHeaderUtil;
import kd.isc.iscb.util.script.misc.HttpUtil;

public class SendMultipart
implements NativeFunction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(ScriptContext ctx, Object[] args) {
        String url = this.mergeUrl(args);
        String method = this.getMethod(args[2]);
        Map cookies = HttpHeaderUtil.copyHeaders((Object[])args, (int)5);
        Map headers = HttpHeaderUtil.copyHeaders((Object[])args, (int)6);
        String boundary = Util.findBoundaryInHeaders(headers);
        if (boundary == null) {
            boundary = Util.newBoundary();
            headers.put("Content-Type", Util.generateMultipartContentType(boundary));
        }
        MultipartBody multipartBody = new MultipartBody((Map)args[3], this.getCharset(args[4]), boundary);
        byte[] body = multipartBody.toByteArray();
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(cookies, headers);
        InputStream inputStream = NetUtil.httpAccess((String)url, (String)method, (byte[])body, null, (NetUtil.ConnectionDecorator)decorator, (int)this.getTimeOut(args));
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            String result = NetUtil.readText((Reader)reader);
            Object object = HttpUtil.compositeReturns((int)decorator.getResponseCode(), (Map)cookies, (Map)headers, (Object)result);
            return object;
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    private String mergeUrl(Object[] args) {
        HttpConnectionWrapper cn = (HttpConnectionWrapper)args[0];
        String website = D.s((Object)cn.get("$website"));
        String relativePath = D.s((Object)args[1]);
        if (relativePath != null) {
            if (relativePath.startsWith("/")) {
                return website + relativePath;
            }
            return website + "/" + relativePath;
        }
        return website;
    }

    private String getMethod(Object arg) {
        String s = D.s((Object)arg);
        return s != null ? s : "POST";
    }

    private String getCharset(Object arg) {
        String s = D.s((Object)arg);
        return s != null ? s : "utf-8";
    }

    private int getTimeOut(Object[] args) {
        int define;
        int timeout = D.i((Object)System.getProperty("net_timeout", "300000"));
        if (args.length == 8 && (define = D.i((Object)args[7])) > 0) {
            timeout = Math.min(define, 3 * timeout);
        }
        return timeout;
    }

    public String name() {
        return "sendMultipart";
    }
}

