/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.imp;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.cache.CacheableObjectSaveOp;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.imp.AbstractFileResourceJob;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.imp.SolutionSyncCloudUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.permission.ImportController;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;

public abstract class AbstractResourceImportJob
extends AbstractFileResourceJob {
    protected int total = 0;
    protected AtomicInteger success = new AtomicInteger(0);
    protected AtomicInteger failed = new AtomicInteger(0);
    protected AtomicInteger omitted = new AtomicInteger(0);
    private String current;

    public AbstractResourceImportJob(long id, String title) {
        super(id, title);
    }

    @Override
    public abstract JobFactory getFactory();

    @Override
    public String refreshProgress() {
        return this.getJobSummary();
    }

    @Override
    public String getJobSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u603b\u6570\uff1a%1$s\uff1b\u6210\u529f\uff1a%2$s", (String)"AbstractResourceImportJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, this.success));
        if (this.omitted.get() > 0) {
            sb.append('\uff1b');
            sb.append(String.format(ResManager.loadKDString((String)"\u5ffd\u7565\uff1a%1$s", (String)"AbstractResourceImportJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.omitted));
        }
        if (this.failed.get() > 0) {
            sb.append('\uff1b');
            sb.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff1a%s\uff0c\u8bf7\u9009\u62e9\u5931\u8d25\u72b6\u6001\u7684\u8d44\u6e90\u67e5\u770b\u8be6\u60c5\u3002", (String)"AbstractResourceImportJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.failed));
        }
        return sb.toString();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        int completed = this.success.get() + this.failed.get() + this.omitted.get();
        return new Job.Progress(this.total, completed, this.current);
    }

    @Override
    public void run() {
        CacheableObjectSaveOp.beginImporting();
        try {
            this.doImporting();
        }
        finally {
            CacheableObjectSaveOp.endImporting();
        }
    }

    private void doImporting() {
        long id = this.getId();
        try {
            FileResourceUtil.setImporting(id);
            List<Map<String, Object>> resources = this.loadParsedResources();
            this.total = resources.size();
            for (Map<String, Object> res : resources) {
                SignalManager.checkCancelSignal();
                String table = D.s((Object)res.get("table"));
                long entryid = D.l((Object)res.get("fentryid"));
                try {
                    this.tryImporting(res, table, entryid);
                }
                catch (Exception e) {
                    this.failed.incrementAndGet();
                    FileResourceUtil.setEntryState(table, entryid, "FAILED", e);
                }
            }
            FileResourceUtil.setImported(id, this.success.get(), this.failed.get(), this.omitted.get(), this.total);
            SolutionSyncCloudUtil.uploadSolutionDeployInfo(id, this.success.get(), this.failed.get(), this.omitted.get(), "S");
        }
        catch (TaskCancelException e) {
            FileResourceUtil.setCanceled(id);
            throw D.e((Throwable)e);
        }
        catch (Exception e) {
            SolutionSyncCloudUtil.uploadSolutionDeployInfo(id, this.success.get(), this.failed.get(), this.omitted.get(), "F");
            FileResourceUtil.setFailed(id);
            throw D.e((Throwable)e);
        }
    }

    private void tryImporting(Map<String, Object> res, String table, long entryid) {
        String state = D.s((Object)res.get("fstate"));
        if (this.isReadyState(state)) {
            this.doImporting(table, entryid, res);
        }
    }

    private void doImporting(String table, long entryid, Map<String, Object> res) {
        String entityTitle = D.s((Object)res.get("ftype"));
        this.current = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\uff1a%1$s-%2$s...", (String)"AbstractResourceImportJob_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityTitle, res.get("number"));
        if (this.isOmitted(table, entryid)) {
            FileResourceUtil.setEntryState(table, entryid, "OMITTED", null);
            this.omitted.incrementAndGet();
        } else {
            String json = this.loadRes(table, entryid);
            ImportDynamicObject.innerImport(Collections.singletonList(json));
            FileResourceUtil.setEntryState(table, entryid, "SUCCESS", null);
            this.success.incrementAndGet();
        }
    }

    protected boolean isOmitted(String table, long entryId) {
        return ImportController.isOmitted(table, entryId);
    }

    private String loadRes(String table, long entryid) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "SELECT fcontent FROM " + table + " WHERE FENTRYID = ?";
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(entryid), Collections.singletonList(-5));
            if (row != null) {
                String string = (String)row.get((Object)"fcontent");
                return string;
            }
            throw new IscBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"AbstractResourceImportJob_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private boolean isReadyState(String state) {
        switch (state) {
            case "SUCCESS": {
                this.success.incrementAndGet();
                return false;
            }
            case "OMITTED": {
                this.omitted.incrementAndGet();
                return false;
            }
            case "FAILED": {
                this.failed.incrementAndGet();
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> loadParsedResources() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
            this.loadParsedResources(cn, "T_ISCB_DTS_IMP_RRS2", resources);
            this.loadParsedResources(cn, "T_ISCB_DTS_IMP_MRS2", resources);
            ArrayList<Map<String, Object>> arrayList = resources;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void loadParsedResources(Connection cn, String table, List<Map<String, Object>> resources) {
        String sql = "SELECT fentryid, foperation, ftype, fres_pk, fstate, fname, fnumber FROM " + table + " WHERE fid=? ORDER BY fseq";
        for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(this.getId()), Collections.singletonList(-5))) {
            Map item = row.toMap();
            item.put("table", table);
            resources.add(item);
        }
    }
}

