/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.imp;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.imp.AbstractFileResourceJob;
import kd.isc.iscb.platform.core.imp.FileResourceParseJobFactory;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.MultiLangUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public final class FileResourceParseJob
extends AbstractFileResourceJob {
    public static final JobFactory FACTORY = new FileResourceParseJobFactory();
    private String mainResEntity;
    private int total_files = 0;
    private AtomicInteger completed_files = new AtomicInteger(0);
    private AtomicInteger omitted_files = new AtomicInteger(0);
    private List<String> omitted_file_names = new ArrayList<String>();
    private Set<String> omitted_file_res_names = new LinkedHashSet<String>();
    private volatile String current_file;
    private AtomicInteger current_count = new AtomicInteger(-1);
    private AtomicInteger current_completed = new AtomicInteger(0);
    private Map<String, String> entities = new HashMap<String, String>(32);
    private HashSet<String> ref_imported = new HashSet(256);
    private HashSet<String> main_imported = new HashSet(256);

    public FileResourceParseJob(long id, String title) {
        super(id, title);
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return this.completed_files + "/" + this.total_files;
    }

    @Override
    public String getJobSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u89e3\u6790 %1$s \u4e2a\u6587\u4ef6\uff0c\u6709\u6548\u6587\u4ef6\uff1a%2$s\u4e2a", (String)"FileResourceParseJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total_files, this.completed_files));
        if (!this.omitted_file_names.isEmpty()) {
            sb.append('\uff0c').append(String.format(ResManager.loadKDString((String)"\u5ffd\u7565\u6587\u4ef6\uff1a%s\u4e2a\u3002", (String)"FileResourceParseJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.omitted_files));
        }
        return sb.toString();
    }

    private String getDetailedSummary() {
        String mainResEntityName = EntityMetadataCache.getDataEntityType((String)this.mainResEntity).getDisplayName().getLocaleValue();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u89e3\u6790 %1$s \u4e2a\u6587\u4ef6\uff0c\u6709\u6548\u6587\u4ef6\uff1a%2$s\u4e2a", (String)"FileResourceParseJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total_files, this.completed_files));
        if (this.omitted_file_names.isEmpty()) {
            sb.append('\u3002');
        } else {
            String importFileResNames = this.getImportFileResNames();
            String tips = String.format(ResManager.loadKDString((String)"\u5ffd\u7565\u6587\u4ef6\uff1a%1$s\u4e2a\u3002\u5ffd\u7565\u539f\u56e0\uff1a\u6587\u4ef6\u7c7b\u578b\u4e0d\u5c5e\u4e8e%2$s\u6587\u4ef6\u7c7b\u578b\uff0c\u8bf7\u5728%3$s\u8d44\u6e90\u5217\u8868\u754c\u9762\u5bfc\u5165\u3002", (String)"FileResourceParseJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.omitted_files, mainResEntityName, importFileResNames);
            sb.append('\uff0c').append(tips);
            sb.append("\r\n\r\n\r\n").append(ResManager.loadKDString((String)"\u5ffd\u7565\u7684\u6587\u4ef6\u662f\uff1a", (String)"FileResourceParseJob_11", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append("\r\n\u25cf ").append(StringUtil.join(this.omitted_file_names, (String)"\r\n\u25cf "));
        }
        return sb.toString();
    }

    private String getImportFileResNames() {
        return String.join((CharSequence)",", this.omitted_file_res_names);
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        int current_count = this.current_count.get();
        int completed_files = this.completed_files.get();
        if (current_count < 0) {
            return new Job.Progress(this.total_files, completed_files, String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u7b2c%s\u4e2a\u6587\u4ef6...", (String)"FileResourceParseJob_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), completed_files + 1));
        }
        String description = this.current_file + "(" + this.current_completed + "/" + current_count + ") ...";
        return new Job.Progress(this.total_files, completed_files, description);
    }

    @Override
    public void run() {
        long id = this.getId();
        try {
            this.mainResEntity = this.loadMainResEntity();
            List<Map<String, Object>> files = AttachmentUtil.getAttachmentList("isc_dts_imp", id);
            SignalManager.checkCancelSignal();
            this.total_files = files.size();
            this.loadParsedResources();
            this.parseResourceFiles(files);
            FileResourceUtil.setParsed(id, this.getDetailedSummary());
        }
        catch (Exception e) {
            FileResourceUtil.setFailed(id);
            throw D.e((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadMainResEntity() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "SELECT fres_type FROM t_iscb_dts_imp_header WHERE fid=?";
            Object value = DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(this.getId()), Collections.singletonList(-5));
            String entityTitle = D.s((Object)value);
            if (entityTitle == null) {
                String string = "isc_metadata_schema";
                return string;
            }
            String string = FileResourceUtil.getEntityName(entityTitle);
            return string;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void loadParsedResources() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            this.loadParsedResources(cn, "T_ISCB_DTS_IMP_RRS2", this.ref_imported);
            this.loadParsedResources(cn, "T_ISCB_DTS_IMP_MRS2", this.main_imported);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void loadParsedResources(Connection cn, String table, HashSet<String> imported) {
        String sql = "SELECT fres_pk,ftype FROM " + table + " WHERE fid=?";
        for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(this.getId()), Collections.singletonList(-5))) {
            Object entityTitle = row.get((Object)"ftype");
            Object resPk = row.get((Object)"fres_pk");
            imported.add(this.generateResKey(entityTitle, resPk));
        }
    }

    private void parseResourceFiles(List<Map<String, Object>> files) {
        for (Map<String, Object> file : files) {
            SignalManager.checkCancelSignal();
            String[] jsons = this.readDtsFile(file);
            String fileName = this.getFileName(file);
            this.resetProgress(jsons, fileName);
            if (this.isValid(jsons)) {
                this.parseResourceFile(jsons, fileName);
                this.completed_files.incrementAndGet();
                continue;
            }
            this.omitted_file_res_names.add(this.getMainEntityName(jsons));
            this.omitted_file_names.add(fileName);
            this.omitted_files.incrementAndGet();
        }
    }

    private String getMainEntityName(String[] jsons) {
        for (int i = jsons.length - 1; i >= 0; --i) {
            boolean isMainRes;
            String json = jsons[i];
            Map data = (Map)Json.toObject((String)json);
            if (data == null) continue;
            boolean bl = isMainRes = !D.x(data.get("$isref"));
            if (!isMainRes) continue;
            return EntityMetadataCache.getDataEntityType((String)D.s(data.get("$entityname"))).getDisplayName().getLocaleValue();
        }
        throw new IscBizException("The file is illegal and the main resource type was not recognized");
    }

    private boolean isValid(String[] jsons) {
        for (int i = jsons.length - 1; i >= 0; --i) {
            boolean isMainRes;
            String json = jsons[i];
            Map data = (Map)Json.toObject((String)json);
            if (data == null) continue;
            String realEntity = (String)data.get("$entityname");
            boolean bl = isMainRes = !D.x(data.get("$isref"));
            if (!isMainRes || !this.mainResEntity.equals(realEntity)) continue;
            return true;
        }
        return false;
    }

    private void parseResourceFile(String[] jsons, String file) {
        for (String json : jsons) {
            SignalManager.checkCancelSignal();
            this.current_completed.incrementAndGet();
            Map data = (Map)Json.toObject((String)json);
            if (data == null) continue;
            this.saveResourceData(data, file);
        }
    }

    private void saveResourceData(Map<String, Object> data, String file) {
        boolean isRef = D.x((Object)data.get("$isref"));
        data.put("$isref", Boolean.FALSE);
        String json = Json.toString(data);
        file = StringUtil.trim((String)file, (int)50);
        String entityTitle = this.innerGetEntityTitle(D.s((Object)data.get("$entityname")));
        Object resPk = data.get("id");
        if (isRef) {
            if (this.ref_imported.add(this.generateResKey(entityTitle, resPk))) {
                this.saveRefResource(json, data, entityTitle, file);
            }
        } else if (this.main_imported.add(this.generateResKey(entityTitle, resPk))) {
            this.saveMainResource(json, data, entityTitle, file);
        }
    }

    private String generateResKey(Object entityTitle, Object resPk) {
        return resPk + "@" + entityTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMainResource(String json, Map<String, Object> data, String entityTitle, String file) {
        int seq = this.main_imported.size();
        long entryId = IDService.get().genLongId();
        String name = this.getResName(data);
        String number = this.getNumber(data);
        String resPk = D.s((Object)data.get("id"));
        String entity = D.s((Object)data.get("$entityname"));
        Timestamp localTime = this.getLocalTime(entity, resPk);
        Timestamp resTime = D.t((Object)data.get(this.getTimeField(entity)));
        String operation = "UPDATE";
        String state = "READY";
        String sourceTrace = D.s((Object)data.get("source_trace"));
        sourceTrace = sourceTrace == null ? " " : sourceTrace;
        String sql = "INSERT INTO T_ISCB_DTS_IMP_MRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FRES_TIME,FLOCAL_TIME,FSTATE,         FCONTENT,FRES_PK, FTYPE, FFILE, FSOURCE_TRACE)VALUES(?,?,?,?,    ?,?,?,?,?,    ?,?,?,?,?)";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 93, 93, 12, 12, 12, 12, 12, 12);
        List<Object> values = Arrays.asList(this.getId(), entryId, seq, operation, name, number, resTime, localTime, state, json, resPk, entityTitle, file, sourceTrace);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private String getNumber(Map<String, Object> data) {
        String number = D.s((Object)data.get("number"));
        return number == null ? ResManager.loadKDString((String)"(\u65e0)", (String)"FileResourceParseJob_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : number;
    }

    private Timestamp getLocalTime(String entity, String pk) {
        String field = this.getTimeField(entity);
        boolean hasField = EntityMetadataCache.getDataEntityType((String)entity).getProperties().containsKey((Object)field);
        DynamicObject obj = null;
        if (hasField) {
            Object id = FileResourceUtil.parseResPK(pk, entity);
            obj = QueryServiceHelper.queryOne((String)entity, (String)field, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        }
        return obj == null ? null : D.t((Object)obj.get(field));
    }

    private String getTimeField(String entity) {
        switch (entity) {
            case "isc_apic_permission": {
                return "created_time";
            }
            case "iscx_resource_ext": {
                return "extended_time";
            }
        }
        return "modifytime";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRefResource(String json, Map<String, Object> data, String entityTitle, String file) {
        int seq = this.ref_imported.size();
        long entryId = IDService.get().genLongId();
        String name = this.getResName(data);
        String number = this.getNumber(data);
        String resPk = D.s((Object)data.get("id"));
        String entity = D.s((Object)data.get("$entityname"));
        Timestamp localTime = this.getLocalTime(entity, resPk);
        Timestamp resTime = D.t((Object)data.get(this.getTimeField(entity)));
        String operation = "INSERT";
        String state = "READY";
        String sourceTrace = D.s((Object)data.get("source_trace"));
        sourceTrace = sourceTrace == null ? " " : sourceTrace;
        String sql = "INSERT INTO T_ISCB_DTS_IMP_RRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FTYPE,FRES_TIME,    FLOCAL_TIME,FSTATE,FCONTENT,FRES_PK, FFILE, FSOURCE_TRACE)VALUES(?,?,?,?,     ?,?,?,?,    ?,?,?,?,?,?)";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 12, 93, 93, 12, 12, 12, 12, 12);
        List<Object> values = Arrays.asList(this.getId(), entryId, seq, operation, name, number, entityTitle, resTime, localTime, state, json, resPk, file, sourceTrace);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private String getResName(Map<String, Object> data) {
        String s = MultiLangUtil.getMultiLangValue(data.get("name"));
        return s == null ? ResManager.loadKDString((String)"(\u65e0)", (String)"FileResourceParseJob_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : s;
    }

    private String innerGetEntityTitle(String entity) {
        String title = this.entities.get(entity);
        if (title == null) {
            title = FileResourceUtil.getEntityTitle(entity);
            this.entities.put(entity, title);
        }
        return title;
    }

    private void resetProgress(String[] jsons, String file) {
        this.current_file = file;
        this.current_count.set(jsons.length);
        this.current_completed.set(0);
    }

    private String getFileName(Map<String, Object> file) {
        return file.get("name") + "." + file.get("type");
    }

    private String[] readDtsFile(Map<String, Object> file) {
        if ("dat".equals(D.s((Object)file.get("type")))) {
            byte[] contentBytes = this.readContentBytes(file);
            String content = this.verifyEncryptedContent(contentBytes, D.s((Object)file.get("name")));
            return content.split("\\n");
        }
        this.current_count.set(-1);
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        String content = NetUtil.readText((InputStream)fileService.getInputStream((String)file.get("srcUrl")));
        return content.split("\\n");
    }

    private String verifyEncryptedContent(byte[] contentBytes, String filename) {
        try {
            return new String(Cipher.decrypt((byte[])contentBytes, (String)Cipher.DEFAULT_KEY), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            String tips = ResManager.loadKDString((String)"\u6b64\u6587\u4ef6\uff08%s\uff09\u7684\u5185\u5bb9\u4e0d\u5408\u6cd5", (String)"FileResourceParseJob_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(String.format(tips, filename), (Throwable)e);
        }
    }

    private byte[] readContentBytes(Map<String, Object> file) {
        int BATCH_SIZE = 0x400000;
        BufferedInputStream in = new BufferedInputStream(FileServiceFactory.getAttachmentFileService().getInputStream(D.s((Object)file.get("srcUrl"))));
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(BATCH_SIZE);
        try {
            int temp;
            while ((temp = in.read()) > -1) {
                buffer.write(temp);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw CommonError.INPUT_READER_FAILURE.wrap((Throwable)e);
        }
        finally {
            DbUtil.close((InputStream)in);
            DbUtil.close((OutputStream)buffer);
        }
    }
}

