/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.imp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.imp.JarResourceImportJobFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.ClassInfo;
import kd.isc.iscb.util.script.misc.log.Logger;
import kd.isc.iscb.util.script.misc.log.LoggerFactory;

public class JarResourceImportJob
implements Job {
    public static final JarResourceImportJobFactory FACTORY = new JarResourceImportJobFactory();
    private String title;
    private String _package;
    private volatile transient String progress;
    private volatile int total;
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicInteger failedCount = new AtomicInteger(0);
    private AtomicInteger succeedCount = new AtomicInteger(0);

    public JarResourceImportJob(String title, String _package) {
        this._package = _package;
        this.title = title;
    }

    @Override
    public long getOwnerId() {
        return Hash.mur64((byte[])this._package.getBytes(D.UTF_8));
    }

    @Override
    public String getParam() {
        return this._package;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return this.progress;
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        return new Job.Progress(this.total, this.count.get(), this.progress);
    }

    @Override
    public String getJobSummary() {
        if (this.failedCount.get() > 0) {
            return String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%s", (String)"JarResourceImportJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.succeedCount.get()) + "\n" + String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff1a%s", (String)"JarResourceImportJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.failedCount.get()) + "\n";
        }
        return String.format(ResManager.loadKDString((String)"\u6210\u529f\uff1a%s", (String)"JarResourceImportJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.succeedCount.get()) + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String url = this.getClass().getClassLoader().getResource("kd/isc/iscb/platform/res/Stub.class").toString();
            try (ZipFile zip = ClassInfo.getZipFile((String)url);){
                this.total = this.scan(zip);
                List<String> exceptions = this.doImporting(zip);
                if (this.failedCount.get() > 0) {
                    throw new IscBizException(this.buildErrorMessage(exceptions));
                }
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public String buildErrorMessage(List<String> exceptions) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJobSummary());
        for (String exception : exceptions) {
            sb.append(exception).append('\n');
        }
        return StringUtil.trim((String)sb.toString(), (int)255);
    }

    private List<String> doImporting(ZipFile zip) throws IOException {
        Enumeration<? extends ZipEntry> it = zip.entries();
        ArrayList<String> exceptions = new ArrayList<String>();
        while (it.hasMoreElements()) {
            ZipEntry e = it.nextElement();
            String name = e.getName();
            this.progress = name.substring(name.lastIndexOf(47) + 1) + '\n' + this.getJobSummary();
            if (!this.isRequiredResource(name)) continue;
            SignalManager.checkCancelSignal();
            try {
                ImportDynamicObject.innerImport(zip.getInputStream(e));
                this.succeedCount.incrementAndGet();
            }
            catch (IscBizException ex) {
                exceptions.add(this.failedCount.incrementAndGet() + "\u3001" + StringUtil.getCascadeMessage((Throwable)ex));
                Logger logger = ((LoggerFactory)LoggerFactory.REF.get()).getLogger(JarResourceImportJob.class);
                logger.warn("imported dts failed," + StringUtil.getCascadeMessage((Throwable)ex), (Throwable)ex);
            }
            this.count.incrementAndGet();
            D.sleep((long)50L);
        }
        return exceptions;
    }

    private boolean isRequiredResource(String name) {
        return name.endsWith(".dts") && name.startsWith(this._package);
    }

    private int scan(ZipFile zip) {
        Enumeration<? extends ZipEntry> it = zip.entries();
        int total = 0;
        while (it.hasMoreElements()) {
            String name = it.nextElement().getName();
            if (!this.isRequiredResource(name)) continue;
            ++total;
        }
        return total;
    }
}

