/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.imp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.imp.MServiceImportJobFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.misc.ClassInfo;

public class MServiceImportJob
implements Job {
    private static final Log LOGGER = LogFactory.getLog(MServiceImportJob.class);
    public static final MServiceImportJobFactory FACTORY = new MServiceImportJobFactory();
    private String title;
    private String _package;
    private volatile AtomicInteger total = new AtomicInteger(0);
    private final AtomicInteger success = new AtomicInteger(0);
    private final AtomicInteger failed = new AtomicInteger(0);

    public MServiceImportJob(String title, String _package) {
        this.title = title;
        this._package = _package;
    }

    @Override
    public long getOwnerId() {
        return Hash.mur64((byte[])this._package.getBytes(D.UTF_8));
    }

    @Override
    public String getJobSummary() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5b8c\u6210\uff0c\u603b\u6570\uff1a%1$s\uff1b\u6210\u529f\uff1a%2$s", (String)"MServiceImportJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, this.success));
        if (this.failed.get() > 0) {
            builder.append('\uff1b');
            builder.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff1a%1$s\u3002\n\u8bf7\u6839\u636etraceId\uff1a%2$s\u5728monitor\u67e5\u770b\u539f\u56e0", (String)"MServiceImportJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.failed, RequestContext.get().getTraceId()));
        }
        return builder.toString();
    }

    @Override
    public String getParam() {
        return this._package;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        MultiLangEnumBridge multiLangEnumBridge = new MultiLangEnumBridge("\u540c\u6b65\u4e2d\uff0c\u603b\u8ba1\uff1a%1$s\uff0c\u6210\u529f\uff1a%2$s\uff0c \u5931\u8d25\uff1a%3$s", "MServiceImportJob_12", "isc-iscb-platform-core");
        String s = String.format(multiLangEnumBridge.loadKDString(), this.total, this.success.get(), this.failed.get());
        return new Job.Progress(this.total.get(), this.success.get() + this.failed.get(), s);
    }

    @Override
    public void run() {
        try {
            String url = this.getClass().getClassLoader().getResource("kd/isc/iscb/platform/res/Stub.class").toString();
            try (ZipFile zip = ClassInfo.getZipFile((String)url);){
                this.doImporting(zip);
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private void doImporting(ZipFile zip) throws IOException {
        Enumeration<? extends ZipEntry> it = zip.entries();
        while (it.hasMoreElements()) {
            ZipEntry e = it.nextElement();
            String name = e.getName();
            if (!this.isRequiredResource(name)) continue;
            SignalManager.checkCancelSignal();
            InputStream dtsFileInputStream = zip.getInputStream(e);
            String dtsFileContent = NetUtil.readText((InputStream)dtsFileInputStream);
            List<String> dts = MServiceImportJob.toList(dtsFileContent);
            this.total.addAndGet(this.getTotal(dts));
            for (String dt : dts) {
                Map dtMap = (Map)Json.toObject((String)dt);
                try {
                    ImportDynamicObject.executeImport(dtMap);
                    String entityName = dtMap.get("$entityname").toString();
                    if (!"isc_apic_mservice".equals(entityName)) continue;
                    this.success.incrementAndGet();
                }
                catch (Exception ex) {
                    this.failed.incrementAndGet();
                    if (ex.getMessage().contains("\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879")) {
                        LOGGER.warn("\u540c\u6b65\u9884\u7f6e\u96c6\u6210\u4e91\u5fae\u670d\u52a1\u5931\u8d25\uff0c\u5fae\u670d\u52a1\u767b\u8bb0\u6709\u552f\u4e00\u6027\u6821\u9a8c\uff0c\u8bf7\u68c0\u67e5\u5df2\u767b\u8bb0\u7684\u975e\u9884\u7f6e\u96c6\u6210\u4e91\u5fae\u670d\u52a1\u3002\u5982\u679c\u8be5\u5fae\u670d\u52a1\u4e0d\u9700\u8981\u4f7f\u7528\u9884\u7f6e\u7684\uff0c\u5219\u8be5\u9519\u8bef\u53ef\u4ee5\u5ffd\u7565\u3002", (Throwable)ex);
                        continue;
                    }
                    LOGGER.warn("\u540c\u6b65\u9884\u7f6e\u96c6\u6210\u4e91\u5fae\u670d\u52a1\u5931\u8d25\u3002", (Throwable)ex);
                }
            }
            D.sleep((long)50L);
        }
    }

    private int getTotal(List<String> dts) {
        int total = 0;
        for (String dt : dts) {
            Map dtMap = (Map)Json.toObject((String)dt);
            String entityName = dtMap.get("$entityname").toString();
            if (!"isc_apic_mservice".equals(entityName)) continue;
            ++total;
        }
        return total;
    }

    private boolean isRequiredResource(String name) {
        return name.endsWith(".dts") && name.startsWith(this._package);
    }

    private static List<String> toList(String s) {
        int i = 0;
        int j = s.indexOf(10);
        ArrayList<String> dts = new ArrayList<String>(16);
        while (j > 0) {
            MServiceImportJob.appendDynamicObject(dts, s, i, j);
            i = j + 1;
            j = s.indexOf(10, i + 1);
        }
        MServiceImportJob.appendDynamicObject(dts, s, i, s.length());
        return dts;
    }

    private static void appendDynamicObject(ArrayList<String> dts, String s, int i, int j) {
        String o = D.s((Object)s.substring(i, j));
        if (o != null) {
            dts.add(o);
        }
    }
}

