/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.inject;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.ReflectionUtil;

public class InjectionUtil {
    private static Log logger = LogFactory.getLog(InjectionUtil.class);
    private static Map<Class<?>, Object> services = new HashMap();

    private static void initServices() throws IOException {
        InputStream in = InjectionUtil.class.getClassLoader().getResourceAsStream("iscb/inject/inject_services.properties");
        try {
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                InjectionUtil.registerServices(properties);
            }
        }
        finally {
            DbUtil.close((InputStream)in);
        }
    }

    private static void registerServices(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String interfaceName = D.s((Object)entry.getKey());
            String serviceImplName = D.s((Object)entry.getValue());
            if (interfaceName == null || serviceImplName == null) continue;
            InjectionUtil.registerService(interfaceName, serviceImplName);
        }
    }

    private static void registerService(String interfaceName, String serviceImplName) {
        try {
            Class interfaceClass = ReflectionUtil.getClass((String)interfaceName);
            services.put(interfaceClass, ReflectionUtil.newInstance((String)serviceImplName));
        }
        catch (Throwable e) {
            logger.warn("register interface\u3010" + interfaceName + "\u3011, serviceImpl\u3010" + serviceImplName + "\u3011caught exception:", e);
        }
    }

    public static <T> T getService(Class<T> interfaceClass) {
        Object o = services.get(interfaceClass);
        if (o != null) {
            return (T)o;
        }
        throw new IscBizException("cannot find interface\u3010" + interfaceClass.getName() + "\u3011 's implementation , please check iscb/inject/inject_service.properties file.");
    }

    static {
        try {
            InjectionUtil.initServices();
        }
        catch (Throwable e) {
            logger.warn("load inject services error", e);
        }
    }
}

