/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobMutex;
import kd.isc.iscb.platform.core.job.JobRunner;
import kd.isc.iscb.platform.core.task.Task;

public abstract class AbstractJobProxy
implements Task {
    private Job job;
    private String id;
    private long jobId;

    protected AbstractJobProxy(String account, long jobId, Job job) {
        this.job = job;
        this.jobId = jobId;
        this.id = AbstractJobProxy.taskId(jobId, account);
    }

    static String taskId(long jobId) {
        String accountId = RequestContext.get().getAccountId();
        return AbstractJobProxy.taskId(jobId, accountId);
    }

    private static String taskId(long jobId, String accountId) {
        return jobId + "@" + accountId;
    }

    Job getJob() {
        return this.job;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    public final long getMutex() {
        return this.job.getMutex();
    }

    @Override
    public final void run() {
        if (JobMutex.require(this)) {
            try {
                JobRunner.doJob(this.jobId, this.job);
            }
            catch (Throwable e) {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("id", this.id);
                args.put("title", this.job.getTitle());
                args.put("param", this.job.getParam());
                JobRunner.handleError(this.jobId, e, args);
            }
            finally {
                JobMutex.release(this);
            }
        }
    }

    @Override
    public final boolean isJob() {
        return true;
    }

    public final String toString() {
        return this.job.getTitle();
    }
}

