/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.job.JobLoader;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public interface Job {
    public String getParam();

    public String getTitle();

    default public boolean isLightTask() {
        return false;
    }

    default public long getMutex() {
        return 0L;
    }

    public JobFactory getFactory();

    public void run();

    default public Returns runX() {
        this.run();
        return Returns.DEFAULT;
    }

    default public String refreshProgress() {
        return null;
    }

    default public long getOwnerId() {
        return -Math.abs(Hash.mur((Object[])new Object[]{this.getClass().getName()}));
    }

    default public Progress getRealtimeProgress() {
        return null;
    }

    default public String getJobSummary() {
        return null;
    }

    public static interface Returns {
        public static final Returns DEFAULT = new Returns(){

            @Override
            public void postHandle(long jobId, Job job) {
                JobState.setComplete(jobId, job);
            }
        };
        public static final Returns DESTRUCTION = new Returns(){

            @Override
            public void postHandle(long jobId, Job job) {
                JobState.delete(jobId);
            }
        };

        public void postHandle(long var1, Job var3);

        public static Returns delay(final int seconds) {
            return new Returns(){

                @Override
                public void postHandle(long jobId, Job job) {
                    JobState.resetReady(jobId, job, seconds);
                    JobLoader.reschedule(jobId, job, seconds);
                }
            };
        }
    }

    public static final class Progress {
        private long totalWork;
        private long completedWork;
        private String description;
        private JobState state;
        private String stackTrace;

        private Progress() {
        }

        public Progress(long totalWork, long completedWork, String description) {
            this(totalWork, completedWork, description, null);
        }

        Progress(long totalWork, long completedWork, String description, String stackTrace) {
            totalWork = Math.max(totalWork, 1L);
            completedWork = Math.max(completedWork, 0L);
            totalWork = Math.max(totalWork, completedWork);
            description = StringUtil.trim((String)description, (String)ResManager.loadKDString((String)"\u6267\u884c\u4e2d...", (String)"Job_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            this.state = JobState.RUNNING;
            this.totalWork = totalWork;
            this.completedWork = completedWork;
            this.description = description;
            this.stackTrace = stackTrace;
        }

        Progress(Timestamp scheduledTime, JobState state, String description, String stackTrace) {
            assert (state != null);
            assert (description != null);
            this.state = state;
            this.description = description;
            this.stackTrace = stackTrace;
            this.totalWork = 10000L;
            long elapsed = (System.currentTimeMillis() - D.l((Object)scheduledTime)) / 1000L;
            this.completedWork = (int)Math.min(9999.0, Math.log(Math.max(1L, elapsed)) * 10.0);
        }

        public long getTotalWork() {
            return this.totalWork;
        }

        public long getCompletedWork() {
            return this.completedWork;
        }

        public String getDescription() {
            return this.description;
        }

        public JobState getState() {
            return this.state;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        public String toString() {
            return this.toString(this.stackTrace);
        }

        public String toString(String stackTrace) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("c", this.completedWork);
            map.put("w", this.totalWork);
            map.put("s", (Object)this.state);
            map.put("d", this.description);
            map.put("t", stackTrace);
            return Json.toString(map);
        }

        static Progress restore(String json) {
            Map map = (Map)Json.toObject((String)json);
            Progress progress = new Progress();
            progress.completedWork = D.l(map.get("c"));
            progress.totalWork = D.l(map.get("w"));
            progress.state = JobState.valueOf((String)map.get("s"));
            progress.description = (String)map.get("d");
            progress.stackTrace = (String)map.get("t");
            return progress;
        }
    }
}

