/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.lang.Lang;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobLoader;
import kd.isc.iscb.platform.core.job.JobMutex;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.Triple;

public class JobCoordinator
implements DaemonTask {
    private String id = UUID.randomUUID().toString();
    private static Map<String, Pair<String, Set<Long>>> mutexes = new HashMap<String, Pair<String, Set<Long>>>();
    private static volatile boolean initiated = false;

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (Map.Entry<String, Pair<String, Set<Long>>> e : JobCoordinator.takeMutexes().entrySet()) {
                String account = e.getKey();
                String tenant = (String)e.getValue().getKey();
                Set mutexIds = (Set)e.getValue().getValue();
                Object[] params = new Object[]{account, tenant, mutexIds};
                String clazz = JobCoordinator.class.getName();
                BroadcastService.broadcastMessageWithApp((String)"iscb", (String)clazz, (String)"mqNotifyJobLoader", (Object[])params);
            }
        }
        finally {
            ScheduleManager.submit((Task)this, this.getInterval());
        }
    }

    private int getInterval() {
        int interval;
        try {
            interval = D.i((Object)ContextUtil.getTenantProperty("isc_job_coordinate_interval"));
        }
        catch (Throwable e) {
            interval = 5;
        }
        return interval <= 0 ? 5 : interval;
    }

    public static void mqNotifyJobLoader(String account, String tenant, final Set<Long> mutexIds) {
        JobCoordinator.init();
        RequestContext ctx = ContextUtil.createRequestContext(account, tenant);
        ScheduleManager.submit((Task)new DaemonTask(){
            private String id = UUID.randomUUID().toString();

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void run() {
                if (JobMutex.isExecutableOnThisServer(mutexIds)) {
                    JobLoader.notify(System.currentTimeMillis());
                }
            }
        }, ctx, 1);
    }

    private static synchronized Map<String, Pair<String, Set<Long>>> takeMutexes() {
        Map<String, Pair<String, Set<Long>>> current = mutexes;
        if (current.isEmpty()) {
            return Collections.emptyMap();
        }
        mutexes = new HashMap<String, Pair<String, Set<Long>>>();
        return current;
    }

    static synchronized void notifyOtherServer(Job job) {
        JobCoordinator.init();
        RequestContext ctx = RequestContext.get();
        String account = ctx.getAccountId();
        Pair p = mutexes.get(account);
        if (p == null) {
            p = new Pair((Object)ctx.getTenantId(), new HashSet());
            mutexes.put(account, (Pair<String, Set<Long>>)p);
        }
        ((Set)p.getValue()).add(job.getMutex());
    }

    private static synchronized void clear() {
        mutexes.clear();
    }

    public static void mqSstartImmediately(String tenant, String account, String userId, String userName, long jobId) {
        JobCoordinator.init();
        RequestContext ctx = ContextUtil.createRequestContext(account, tenant, userId, userName);
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        Triple<Job, String, Lang> t = JobLoader.restore(jobId);
        Job job = (Job)t.getA();
        if (JobMutex.isExecutableOnThisServer(job)) {
            String creator = (String)t.getB();
            Lang lang = (Lang)t.getC();
            JobLoader.enqueueDirectly(jobId, job, JobCoordinator.createContext(creator, lang));
        }
    }

    static RequestContext createContext(String creator, Lang lang) {
        RequestContext ctx = RequestContext.get();
        if (creator == null || "0".equals(creator)) {
            return ctx;
        }
        return ProxyUserUtil.createRequestContext(ctx, creator, lang);
    }

    private static void init() {
        if (!initiated) {
            JobCoordinator.init0();
        }
    }

    private static synchronized void init0() {
        if (!initiated) {
            ScheduleManager.submit((Task)new JobCoordinator(), 5);
            initiated = true;
        }
    }
}

