/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.lang.Lang;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.check.CheckSFBigLogsJob;
import kd.isc.iscb.platform.core.connector.ischub.job.IscEventJob;
import kd.isc.iscb.platform.core.content.job.ContentSearchJob;
import kd.isc.iscb.platform.core.datacomp.DataCompThread;
import kd.isc.iscb.platform.core.dc.DataCopyJob;
import kd.isc.iscb.platform.core.dc.DataCopyTaskJob;
import kd.isc.iscb.platform.core.dc.e.ExecutionLogRedoJob;
import kd.isc.iscb.platform.core.dc.f.e.ExportDataFileJob;
import kd.isc.iscb.platform.core.dc.f.i.ImportDataFileJob;
import kd.isc.iscb.platform.core.imp.FileResourceImportJob;
import kd.isc.iscb.platform.core.imp.FileResourceParseJob;
import kd.isc.iscb.platform.core.imp.JarResourceImportJob;
import kd.isc.iscb.platform.core.imp.MServiceImportJob;
import kd.isc.iscb.platform.core.job.AbstractJobProxy;
import kd.isc.iscb.platform.core.job.Const;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobCoordinator;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.job.JobLoader;
import kd.isc.iscb.platform.core.job.JobMutex;
import kd.isc.iscb.platform.core.job.JobProgress;
import kd.isc.iscb.platform.core.job.JobRunner;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.platform.core.license.ImportWhiteListFromLocalOnceJob;
import kd.isc.iscb.platform.core.log.CountFailedEventJob;
import kd.isc.iscb.platform.core.log.job.DeleteLogJob;
import kd.isc.iscb.platform.core.log.job.QueryLogJob;
import kd.isc.iscb.platform.core.meta.SyncMetaJob;
import kd.isc.iscb.platform.core.rc.job.CheckHealthJob;
import kd.isc.iscb.platform.core.resource.backup.PullJob;
import kd.isc.iscb.platform.core.resource.backup.PushJob;
import kd.isc.iscb.platform.core.resource.packages.ImportPackagesParseJob;
import kd.isc.iscb.platform.core.resource.packages.PackagesExportJob;
import kd.isc.iscb.platform.core.sf.runtime.EventWaitingJob;
import kd.isc.iscb.platform.core.sf.runtime.ProcessExecuteJob;
import kd.isc.iscb.platform.core.sf.runtime.ProcessSignalJob;
import kd.isc.iscb.platform.core.sf.runtime.ProcessTerminateJob;
import kd.isc.iscb.platform.core.sf.runtime.n.TimerWaitingJobFactory;
import kd.isc.iscb.platform.core.solution.ClearAllSolutionJob;
import kd.isc.iscb.platform.core.solution.ResourceCenterDeployJob;
import kd.isc.iscb.platform.core.solution.SolutionResourceCompareJob;
import kd.isc.iscb.platform.core.solution.SolutionResourceDeployJob;
import kd.isc.iscb.platform.core.solution.SolutionResourceImportJob;
import kd.isc.iscb.platform.core.solution.SolutionResourceUpdateJob;
import kd.isc.iscb.platform.core.solution.UpdateRefResourceJob;
import kd.isc.iscb.platform.core.solution.UpdateResourceListJob;
import kd.isc.iscb.platform.core.startjob.ApiCronJob;
import kd.isc.iscb.platform.core.startjob.FlowCronJob;
import kd.isc.iscb.platform.core.startjob.TriggerCronJob;
import kd.isc.iscb.platform.core.syndata.MapDataJob;
import kd.isc.iscb.platform.core.syndata.SyncDataJob;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.MutexTaskManager;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.vc.MappingResultImportJob;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.ReflectionUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.Triple;
import kd.isc.iscb.util.trace.TraceTask;

public class JobEngine
implements Const {
    private static final ReadLockFreeMap<String, JobFactory> factories = new ReadLockFreeMap();
    private static final ReadLockFreeMap<String, String> masters = new ReadLockFreeMap();

    public static long submit(Job job) {
        return JobEngine.submit(job, new Timestamp(System.currentTimeMillis()));
    }

    public static long submit(Job job, Timestamp scheduledTime) {
        RequestContext ctx = RequestContext.get();
        return JobEngine.submitJob(job, scheduledTime, D.l((Object)ctx.getUserId()), ctx.getLang());
    }

    public static long submitX(Job job, Timestamp scheduledTime, long creator) {
        return JobEngine.submitJob(job, scheduledTime, creator, RequestContext.get().getLang());
    }

    private static long submitJob(Job job, Timestamp scheduledTime, long creator, Lang lang) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        JobState state = JobEngine.determineState(scheduledTime, now);
        DynamicObject obj = JobEngine.createJob(job, scheduledTime, state, now, creator, lang);
        long jobId = JobEngine.saveJobWithTrace(obj);
        JobEngine.enqueueJob(jobId, state, job, scheduledTime);
        return jobId;
    }

    private static long saveJobWithTrace(final DynamicObject obj) {
        long jobId = obj.getLong("id");
        String jobTitle = obj.getString("title");
        TraceStack.run(TraceType.NEW_JOB, jobTitle, jobId, new TraceTask(){

            public void run() {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        });
        return jobId;
    }

    public static long[] submit(Job[] jobs) {
        return JobEngine.submit(jobs, new Timestamp(System.currentTimeMillis()));
    }

    public static long[] submit(Job[] jobs, Timestamp scheduledTime) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        JobState state = JobEngine.determineState(scheduledTime, now);
        DynamicObject[] objs = JobEngine.createJobs(jobs, scheduledTime, state, now);
        SaveServiceHelper.save((DynamicObject[])objs);
        return JobEngine.enqueueJobs(objs, jobs, state, scheduledTime);
    }

    private static JobState determineState(Timestamp scheduledTime, Timestamp now) {
        JobState state = scheduledTime.getTime() - now.getTime() <= 500L ? JobState.READY : JobState.CREATED;
        return state;
    }

    public static void cancel(long jobId) {
        boolean cancelled = JobState.tryCancel(jobId);
        if (!cancelled) {
            JobRunner.cancel(jobId);
        } else {
            JobEngine.setTaskBillTerminated(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTaskBillTerminated(long jobId) {
        DataRow row;
        String sql = "SELECT ftype, fjob_owner FROM t_isc_job_inst WHERE fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            row = DbUtil.executeRow((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{jobId}), (List)D.asList((Object[])new Integer[]{-5}));
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        long jobOwner = D.l((Object)row.get((Object)"fjob_owner"));
        if (jobOwner != 0L) {
            JobFactory factory = JobEngine.getFactory(D.s((Object)row.get((Object)"ftype")));
            factory.cancel(jobOwner);
        }
    }

    public static Job.Progress getProgress(long jobId, boolean requiresRunningStackTrace) {
        Job.Progress progress = JobProgress.getProgress(jobId);
        if (progress != null) {
            if (requiresRunningStackTrace) {
                progress.setStackTrace(JobState.loadStackTrace(jobId));
            }
            return progress;
        }
        Map<String, Object> data = JobState.load(jobId);
        if (data == null) {
            return null;
        }
        JobState state = JobState.valueOf((String)data.get("fstate"));
        String description = JobEngine.generateJobDescription(jobId, data, state);
        String stackTrace = JobEngine.requiresStackTrace(requiresRunningStackTrace, state) ? D.s((Object)data.get("fremark_tag")) : null;
        Timestamp scheduledTime = D.t((Object)data.get("fstarted_time"));
        return new Job.Progress(scheduledTime, state, description, stackTrace);
    }

    private static boolean requiresStackTrace(boolean requiresRunningStackTrace, JobState state) {
        return requiresRunningStackTrace && JobState.RUNNING == state || JobState.FAILED == state;
    }

    private static String generateJobDescription(long jobId, Map<String, Object> data, JobState state) {
        String description = state.isWaiting() ? JobEngine.generateWaitingMessage(jobId) : (String)data.get("fremark");
        return description;
    }

    private static String generateWaitingMessage(long jobId) {
        int count = JobEngine.tasksBefore(jobId);
        if (count < 0) {
            JobLoader.notify(System.currentTimeMillis());
            return "";
        }
        return String.format(ResManager.loadKDString((String)"\u524d\u9762\u8fd8\u6709 %s \u4e2a\u4efb\u52a1\u6b63\u5728\u6392\u961f\uff0c\u8bf7\u7a0d\u5019 ...", (String)"JobEngine_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), count + 1);
    }

    private static int tasksBefore(long jobId) {
        String taskId = AbstractJobProxy.taskId(jobId);
        int count = TaskManager.tasksBefore(taskId);
        if (count < 0) {
            count = LightTaskManager.tasksBefore(taskId);
        }
        if (count < 0) {
            count = MutexTaskManager.tasksBefore(taskId);
        }
        return count;
    }

    private static void enqueueJob(long jobId, JobState state, Job job, Timestamp scheduledTime) {
        if (JobMutex.isExecutableOnThisServer(job)) {
            if (state == JobState.READY) {
                JobLoader.enqueueDirectly(jobId, job);
            } else {
                JobLoader.notify(scheduledTime.getTime());
            }
        } else {
            JobCoordinator.notifyOtherServer(job);
        }
    }

    private static DynamicObject createJob(Job job, Timestamp scheduledTime, JobState state, Timestamp now, long creator, Lang lang) {
        long jobId = IDService.get().genLongId();
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_job_inst");
        obj.set("id", (Object)jobId);
        String type = job.getFactory().getType();
        obj.set("type", (Object)type);
        obj.set("type2", (Object)type);
        obj.set("state", (Object)state.name());
        String title = job.getTitle();
        obj.set("title", (Object)StringUtil.trim((String)(title == null ? "{none}" : title), (int)33));
        String param = job.getParam();
        if (param.length() <= 127) {
            obj.set("param", (Object)param);
        } else {
            obj.set("param", (Object)StringUtil.trim((String)param, (int)80));
            obj.set("param_tag", (Object)param);
        }
        obj.set("host", (Object)StringUtil.trim((String)NetUtil.getServerId(), (int)75));
        obj.set("scheduled_time", (Object)scheduledTime);
        obj.set("creator", (Object)creator);
        obj.set("task_lang", (Object)String.valueOf(lang));
        obj.set("job_owner", (Object)job.getOwnerId());
        obj.set("created_time", (Object)now);
        obj.set("modified_time", (Object)now);
        return obj;
    }

    private static long[] enqueueJobs(DynamicObject[] objs, Job[] jobs, JobState state, Timestamp scheduledTime) {
        long[] jobIds = new long[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            long jobId;
            jobIds[i] = jobId = objs[i].getLong("id");
            Job job = jobs[i];
            JobEngine.enqueueJob(jobId, state, job, scheduledTime);
        }
        return jobIds;
    }

    private static DynamicObject[] createJobs(Job[] jobs, Timestamp scheduledTime, JobState state, Timestamp now) {
        RequestContext ctx = RequestContext.get();
        long userId = D.l((Object)ctx.getUserId());
        Lang lang = ctx.getLang();
        DynamicObject[] objs = new DynamicObject[jobs.length];
        for (int i = 0; i < jobs.length; ++i) {
            Job job = jobs[i];
            objs[i] = JobEngine.createJob(job, scheduledTime, state, now, userId, lang);
        }
        return objs;
    }

    public static JobFactory getFactory(String type) {
        JobFactory factory = (JobFactory)factories.get((Object)type);
        if (factory != null) {
            return factory;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\uff08%s\uff09\u672a\u6ce8\u518c\uff01", (String)"JobEngine_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
    }

    public static JobFactory findFactory(String type) {
        return (JobFactory)factories.get((Object)type);
    }

    public static void register(JobFactory factory) {
        String type = factory.getType();
        if (factories.putIfAbsent((Object)type, (Object)factory) != factory) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\uff08%s\uff09\u5df2\u6ce8\u518c\uff01", (String)"JobEngine_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
        }
    }

    public static boolean isMaster() {
        String accountId = RequestContext.get().getAccountId();
        String master = (String)masters.get((Object)accountId);
        return master == null || TaskManager.getInstanceId().equals(master);
    }

    public static void setMaster(String master) {
        String accountId = RequestContext.get().getAccountId();
        masters.put((Object)accountId, (Object)master);
    }

    public static Map<String, String> getMasters() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.putAll((Map<String, String>)masters);
        return map;
    }

    public static boolean startImmediately(long jobId) {
        boolean ready = JobState.setReady(jobId, true);
        if (ready) {
            Triple<Job, String, Lang> t = JobLoader.restore(jobId);
            Job job = (Job)t.getA();
            if (JobMutex.isExecutableOnThisServer(job)) {
                String creator = (String)t.getB();
                Lang lang = (Lang)t.getC();
                JobLoader.enqueueDirectly(jobId, job, JobCoordinator.createContext(creator, lang));
            } else {
                RequestContext ctx = RequestContext.get();
                BroadcastService.broadcastMessageWithApp((String)"iscb", (String)JobCoordinator.class.getName(), (String)"mqSstartImmediately", (Object[])new Object[]{ctx.getTenantId(), ctx.getAccountId(), ctx.getUserId(), ctx.getUserName(), jobId});
            }
        }
        return ready;
    }

    public static void notify(long scheduledTime) {
        JobLoader.notify(scheduledTime);
    }

    public static boolean resetFailedJob(long jobId) {
        return JobState.resetFailedJob(jobId);
    }

    public static void dropJobByOwnerId(long ownerId) {
        JobState.dropJobByOwnerId(ownerId);
    }

    public static boolean dropNoRunningJobByOwnerId(long ownerId) {
        return JobState.dropNoRunningJobByOwnerId(ownerId);
    }

    public static boolean existsJobWithOwnerId(long ownerId) {
        return JobState.existsJobWithOwnerId(ownerId);
    }

    public static boolean existsRunningJobWithOwnerId(long ownerId) {
        return JobState.existsRunningJobWithOwnerId(ownerId);
    }

    public static List<JobInfo> getJobsWithOwnerId(long ownerId) {
        return JobState.getJobsWithOwnerId(ownerId);
    }

    public static List<JobInfo> getCreatedJobsWithOwnerId(long ownerId) {
        return JobState.getCreatedJobsWithOwnerId(ownerId);
    }

    public static List<JobInfo> getAllJobsWithOwnerId(long ownerId) {
        return JobState.getAllJobsWithOwnerId(ownerId);
    }

    public static void dumpStackTrace(long jobId) {
        boolean dumped = JobProgress.dumpStackTrace(jobId);
        if (!dumped) {
            BroadcastService.broadcastMessageWithApp((String)"iscb", (String)JobProgress.class.getName(), (String)"dumpStackTrace", (Object[])new Object[]{jobId});
        }
    }

    static void init() {
    }

    private static void registerExternalFactories(Properties properties) {
        for (Object value : properties.values()) {
            String className = D.s((Object)value);
            if (className == null) continue;
            try {
                JobFactory factory = (JobFactory)ReflectionUtil.newInstance((String)className);
                JobEngine.register(factory);
            }
            catch (Throwable e) {
                LogFactory.getLog(JobEngine.class).warn(String.format(ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u5f15\u64ce\u6ce8\u518c\u5de5\u5382\u7c7b\u5931\u8d25\uff0c\u5de5\u5382\u7c7b\u662f\uff1a%s", (String)"JobEngine_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), className), e);
            }
        }
    }

    static {
        JobEngine.register(JarResourceImportJob.FACTORY);
        JobEngine.register(DataCopyTaskJob.FACTORY);
        JobEngine.register(MapDataJob.FACTORY);
        JobEngine.register(ProcessExecuteJob.FACTORY);
        JobEngine.register(ProcessTerminateJob.FACTORY);
        JobEngine.register(SyncMetaJob.FACTORY);
        JobEngine.register(SyncDataJob.FACTORY);
        JobEngine.register(TimerWaitingJobFactory.INSTANCE);
        JobEngine.register(DataCompThread.FACTORY);
        JobEngine.register(DataCopyJob.FACTORY);
        JobEngine.register(ImportDataFileJob.FACTORY);
        JobEngine.register(ExportDataFileJob.FACTORY);
        JobEngine.register(ExecutionLogRedoJob.FACTORY);
        JobEngine.register(FileResourceParseJob.FACTORY);
        JobEngine.register(FileResourceImportJob.FACTORY);
        JobEngine.register(CheckSFBigLogsJob.FACTORY);
        JobEngine.register(IscEventJob.FACTORY);
        JobEngine.register(SolutionResourceImportJob.FACTORY);
        JobEngine.register(UpdateRefResourceJob.FACTORY);
        JobEngine.register(SolutionResourceCompareJob.FACTORY);
        JobEngine.register(SolutionResourceUpdateJob.FACTORY);
        JobEngine.register(CheckHealthJob.FACTORY);
        JobEngine.register(SolutionResourceDeployJob.FACTORY);
        JobEngine.register(EventWaitingJob.FACTORY);
        JobEngine.register(ProcessSignalJob.FACTORY);
        JobEngine.register(FlowCronJob.FACTORY);
        JobEngine.register(TriggerCronJob.FACTORY);
        JobEngine.register(ApiCronJob.FACTORY);
        JobEngine.register(CountFailedEventJob.FACTORY);
        JobEngine.register(MappingResultImportJob.FACTORY);
        JobEngine.register(ResourceCenterDeployJob.FACTORY);
        JobEngine.register(UpdateResourceListJob.FACTORY);
        JobEngine.register(QueryLogJob.FACTORY);
        JobEngine.register(DeleteLogJob.FACTORY);
        JobEngine.register(MServiceImportJob.FACTORY);
        JobEngine.register(ClearAllSolutionJob.FACTORY);
        JobEngine.register(ImportPackagesParseJob.FACTORY);
        JobEngine.register(PackagesExportJob.FACTORY);
        JobEngine.register(ContentSearchJob.FACTORY);
        JobEngine.register(PushJob.FACTORY);
        JobEngine.register(PullJob.FACTORY);
        JobEngine.register(ImportWhiteListFromLocalOnceJob.FACTORY);
        try {
            InputStream in = JobEngine.class.getClassLoader().getResourceAsStream("iscb/job_factory.properties");
            try {
                if (in != null) {
                    Properties properties = new Properties();
                    properties.load(in);
                    JobEngine.registerExternalFactories(properties);
                }
            }
            finally {
                DbUtil.close((InputStream)in);
            }
        }
        catch (Throwable e) {
            LogFactory.getLog(JobEngine.class).warn(ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u5f15\u64ce\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"JobEngine_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e);
        }
    }
}

