/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.isc.iscb.platform.core.job.AbstractJobProxy;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.platform.core.job.c.JobMutexLoader;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.util.dt.D;

public class JobMutex {
    private long mutexId;
    private int maxThreads;
    private IdentityHashMap<AbstractJobProxy, Boolean> runningJobs;
    private LinkedHashMap<String, AbstractJobProxy> waitingJobs;
    private static final Map<String, Map<Long, JobMutex>> mutexes = new ConcurrentHashMap<String, Map<Long, JobMutex>>(128);

    private JobMutex(long mutexId, int maxThreads) {
        this.mutexId = mutexId;
        this.maxThreads = Math.max(0, maxThreads);
        this.runningJobs = new IdentityHashMap(128);
        this.waitingJobs = new LinkedHashMap();
    }

    private synchronized boolean push(AbstractJobProxy job) {
        if (this.maxThreads == 0) {
            return false;
        }
        if (this.runningJobs.size() >= this.maxThreads) {
            this.waitingJobs.put(job.getId(), job);
            return false;
        }
        this.runningJobs.put(job, Boolean.TRUE);
        return true;
    }

    private synchronized void pop(AbstractJobProxy job) {
        this.runningJobs.remove(job);
        this.notifyWaitingJobs();
    }

    private synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = Math.max(0, maxThreads);
        this.notifyWaitingJobs();
    }

    private synchronized void notifyWaitingJobs() {
        if (this.maxThreads == 0) {
            this.waitingJobs.clear();
        } else {
            int j = this.maxThreads;
            for (int i = this.runningJobs.size(); i < j; ++i) {
                if (this.waitingJobs.isEmpty()) continue;
                JobMutex.resubmit(this.removeFirst());
            }
        }
    }

    private static void resubmit(AbstractJobProxy first) {
        if (first instanceof LightTask) {
            LightTaskManager.submit((LightTask)((Object)first));
        } else {
            TaskManager.submit(first);
        }
    }

    private synchronized AbstractJobProxy removeFirst() {
        Iterator<Map.Entry<String, AbstractJobProxy>> it = this.waitingJobs.entrySet().iterator();
        AbstractJobProxy next = it.next().getValue();
        it.remove();
        return next;
    }

    public String toString() {
        return String.valueOf(this.mutexId);
    }

    public synchronized List<JobInfo> getRunningJobs() {
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>(this.runningJobs.size());
        for (AbstractJobProxy proxy : this.runningJobs.keySet()) {
            Job job = proxy.getJob();
            jobs.add(new JobInfo(D.l((Object)proxy.getId()), JobState.RUNNING, job.getTitle(), job.getFactory()));
        }
        return jobs;
    }

    public static void refresh(Map<Long, Integer> mutexQuotaMap) {
        Map<Long, JobMutex> mutexMap = JobMutex.getOrNewMutexMap();
        JobMutex.refreshMutexMap(mutexQuotaMap, mutexMap);
    }

    static void release(AbstractJobProxy job) {
        if (job.getMutex() <= 0L) {
            return;
        }
        Map<Long, JobMutex> mutexMap = JobMutex.getOrNewMutexMap();
        JobMutex mutex = mutexMap.get(job.getMutex());
        if (mutex != null) {
            mutex.pop(job);
        }
    }

    static boolean require(AbstractJobProxy job) {
        if (job.getMutex() <= 0L) {
            return true;
        }
        Map<Long, JobMutex> mutexMap = JobMutex.getOrLoadMutexMap();
        JobMutex mutex = mutexMap.get(job.getMutex());
        if (mutex == null) {
            return true;
        }
        return mutex.push(job);
    }

    static boolean isExecutableOnThisServer(Job job) {
        long mutexKey = job.getMutex();
        if (mutexKey <= 0L) {
            return true;
        }
        return JobMutex.isExecutableOnThisServer(mutexKey);
    }

    private static boolean isExecutableOnThisServer(long jobMutex) {
        JobMutex mutex = JobMutex.getOrLoadMutexMap().get(jobMutex);
        return mutex == null || mutex.maxThreads > 0;
    }

    static boolean isExecutableOnThisServer(Set<Long> jobMutexIds) {
        Map<Long, JobMutex> map = JobMutex.getOrLoadMutexMap();
        for (Long mutexId : jobMutexIds) {
            JobMutex mutex = map.get(mutexId);
            if (mutex != null && mutex.maxThreads <= 0) continue;
            return true;
        }
        return false;
    }

    private static void refreshMutexMap(Map<Long, Integer> mutexQuotaMap, Map<Long, JobMutex> mutexMap) {
        for (Map.Entry<Long, Integer> e : mutexQuotaMap.entrySet()) {
            Long mutexId = e.getKey();
            int maxThreads = e.getValue();
            JobMutex mutex = mutexMap.get(mutexId);
            if (mutex == null) {
                mutexMap.putIfAbsent(mutexId, new JobMutex(mutexId, maxThreads));
                continue;
            }
            mutex.setMaxThreads(maxThreads);
        }
    }

    private static Map<Long, JobMutex> getOrNewMutexMap() {
        RequestContext ctx = RequestContext.get();
        String key = ctx.getAccountId();
        Map<Long, JobMutex> mutexMap = mutexes.get(key);
        if (mutexMap == null) {
            mutexes.putIfAbsent(key, new ConcurrentHashMap(64));
            mutexMap = mutexes.get(key);
        }
        return mutexMap;
    }

    private static Map<Long, JobMutex> getOrLoadMutexMap() {
        RequestContext ctx = RequestContext.get();
        String key = ctx.getAccountId();
        Map<Long, JobMutex> mutexMap = mutexes.get(key);
        if (mutexMap == null) {
            new JobMutexLoader().run();
            mutexMap = mutexes.get(key);
        }
        return mutexMap;
    }

    public static void clear() {
        RequestContext ctx = RequestContext.get();
        String key = ctx.getAccountId();
        Map<Long, JobMutex> map = mutexes.remove(key);
        if (map != null) {
            for (JobMutex m : map.values()) {
                for (AbstractJobProxy job : m.waitingJobs.values()) {
                    JobMutex.resubmit(job);
                }
            }
        }
    }
}

