/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.util.ThreadLocals;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.job.JobProgress;
import kd.isc.iscb.platform.core.job.JobState;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.trace.TraceTask;

public class JobRunner
implements MessageConsumer {
    static final String ID = "id";
    static final String TYPE = "type";
    static final String TITLE = "title";
    static final String PARAM = "param";
    private static Log logger = LogFactory.getLog(JobRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        Map args = (Map)body;
        long id = D.l(args.get(ID));
        try {
            Job job = this.restoreJob(args);
            JobRunner.doJob(id, job);
        }
        catch (Throwable e) {
            JobRunner.handleError(id, e, args);
        }
        finally {
            acker.ack(messageId);
            ThreadLocals.release();
        }
    }

    static void handleError(long id, Throwable e, Map<String, Object> args) {
        try {
            if (!JobState.setFailedOnRunning(id, e)) {
                logger.warn("isc_job_runner_is_done_but_failed_to_release, args=" + args, e);
            }
        }
        catch (Throwable e1) {
            e.addSuppressed(e1);
            logger.warn("isc_job_runner_failed, args=" + args, e);
        }
    }

    static void doJob(final long id, final Job job) {
        if (JobState.setRunning(id)) {
            TraceStack.traceJob(id, job.getTitle(), new TraceTask(){

                public void run() {
                    JobRunner.innerExecute(id, job);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void innerExecute(long id, Job job) {
        JobProgress.regRunning(id, job);
        try {
            Job.Returns returns = JobRunner.run(job, String.valueOf(id));
            returns.postHandle(id, job);
        }
        finally {
            JobProgress.unregRunning(id);
        }
    }

    private static Job.Returns run(Job job, String jobId) {
        SignalManager.registerTask(jobId);
        try {
            Job.Returns returns = job.runX();
            return returns;
        }
        finally {
            SignalManager.unregisterTask(jobId);
        }
    }

    static void cancel(long jobId) {
        SignalManager.sendCancelSignal(String.valueOf(jobId));
    }

    private Job restoreJob(Map<String, Object> args) {
        String type = (String)args.get(TYPE);
        JobFactory factory = JobEngine.getFactory(type);
        String param = (String)args.get(PARAM);
        String title = (String)args.get(TITLE);
        return factory.restore(title, param);
    }
}

