/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public enum JobState {
    CREATED{

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isWaiting() {
            return true;
        }
    }
    ,
    WAITING{

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isWaiting() {
            return true;
        }
    }
    ,
    READY{

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isWaiting() {
            return true;
        }
    }
    ,
    RUNNING{

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isWaiting() {
            return false;
        }
    }
    ,
    FAILED{

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public boolean isWaiting() {
            return false;
        }
    }
    ,
    COMPLETE{

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public boolean isWaiting() {
            return false;
        }
    }
    ,
    TERMINATED{

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public boolean isWaiting() {
            return false;
        }
    };

    private static final int TWO_DAY = 172800000;
    private static Log logger;

    public abstract boolean isFinal();

    public abstract boolean isWaiting();

    static boolean tryCancel(long jobId) {
        String sql = "UPDATE t_isc_job_inst SET fstate='TERMINATED',fmodified_time=?,fhost=? WHERE fid=? AND fstate IN('READY','CREATED','WAITING')";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String host = StringUtil.trim((String)NetUtil.getServerId(), (int)75);
        return JobState.executeSql(sql, Arrays.asList(now, host, jobId), Arrays.asList(93, 12, -5));
    }

    static void setFailed(long jobId, Throwable e) {
        String message = StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)e), (int)666);
        String stackTrace = StringUtil.toString((Throwable)e);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String host = StringUtil.trim((String)NetUtil.getServerId(), (int)75);
        String state = e instanceof TaskCancelException ? TERMINATED.name() : FAILED.name();
        String sql = "UPDATE t_isc_job_inst SET fstate=?, fremark=?,fremark_tag=? ,fmodified_time=?,fend_time=?,fhost=? WHERE fid=?";
        try {
            JobState.executeSql(sql, Arrays.asList(state, message, stackTrace, now, now, host, jobId), Arrays.asList(12, 12, 12, 93, 93, 12, -5));
        }
        catch (Exception err) {
            JobState.executeSql(sql, Arrays.asList(state, message, null, now, now, host, jobId), Arrays.asList(12, 12, 12, 93, 93, 12, -5));
            logger.info("\u66f4\u65b0\u540e\u53f0\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff0c\u4f46\u91cd\u8bd5\u540e\u66f4\u65b0\u6210\u529f\u3002", (Object)err);
        }
    }

    static boolean setFailedOnRunning(long jobId, Throwable e) {
        String message = StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)e), (int)666);
        String stackTrace = StringUtil.toString((Throwable)e);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String host = StringUtil.trim((String)NetUtil.getServerId(), (int)75);
        String state = e instanceof TaskCancelException ? TERMINATED.name() : FAILED.name();
        String expected = RUNNING.name();
        String sql = "UPDATE t_isc_job_inst SET fstate=?, fremark=?,fremark_tag=? ,fmodified_time=?,fend_time=?,fhost=? WHERE fid=? AND fstate=?";
        try {
            return JobState.executeSql(sql, Arrays.asList(state, message, stackTrace, now, now, host, jobId, expected), Arrays.asList(12, 12, 12, 93, 93, 12, -5, 12));
        }
        catch (Exception err) {
            boolean b = JobState.executeSql(sql, Arrays.asList(state, message, null, now, now, host, jobId, expected), Arrays.asList(12, 12, 12, 93, 93, 12, -5, 12));
            logger.info("\u66f4\u65b0\u540e\u53f0\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff0c\u4f46\u91cd\u8bd5\u540e\u66f4\u65b0\u6210\u529f\u3002", (Object)err);
            return b;
        }
    }

    static void saveStackTrace(long jobId, String stackTrace) {
        String sql = "UPDATE t_isc_job_inst SET fremark_tag=? WHERE fid=?";
        JobState.executeSql(sql, Arrays.asList(stackTrace, jobId), Arrays.asList(12, -5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, Object> load(long jobId) {
        String sql = "SELECT fstate, fremark, fremark_tag,fstarted_time FROM t_isc_job_inst WHERE fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(jobId), Collections.singletonList(-5));
            return dataRow;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    static String loadStackTrace(long jobId) {
        Map<String, Object> data = JobState.load(jobId);
        return data == null ? null : D.s((Object)data.get("fremark_tag"));
    }

    static void setComplete(long jobId, Job job) {
        String remark = JobState.getRemark(job);
        String sql = "UPDATE t_isc_job_inst SET fremark=?,fremark_tag = null, fstate='COMPLETE',fmodified_time=?,fend_time=? WHERE fid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        JobState.executeSql(sql, Arrays.asList(remark, now, now, jobId), Arrays.asList(12, 93, 93, -5));
    }

    private static String getRemark(Job job) {
        String remark = job.getJobSummary();
        remark = remark == null ? " " : StringUtil.trim((String)remark, (int)666);
        return remark;
    }

    static boolean setRunning(long jobId) {
        String sql = "UPDATE t_isc_job_inst SET fstate='RUNNING',fstarted_time=?,fmodified_time=?,fhost=?, fend_time=null WHERE fid=? AND fstate IN('READY','CREATED','WAITING')";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String host = StringUtil.trim((String)NetUtil.getServerId(), (int)75);
        return JobState.executeSql(sql, Arrays.asList(now, now, host, jobId), Arrays.asList(93, 93, 12, -5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeSql(String sql, List<Object> params, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            int affacted = DbUtil.executeUpdate((Connection)cn, (String)sql, params, types);
            boolean bl = affacted >= 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static boolean setReady(long jobId) {
        return JobState.setReady(jobId, false);
    }

    static boolean setReady(long jobId, boolean force) {
        String sql = force ? "UPDATE t_isc_job_inst SET fstate='READY', fmodified_time=? WHERE fstate IN('CREATED','WAITING','READY') AND fid=?" : "UPDATE t_isc_job_inst SET fstate='READY', fmodified_time=? WHERE fstate  IN('CREATED','WAITING') AND fid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        return JobState.executeSql(sql, Arrays.asList(now, jobId), Arrays.asList(93, -5));
    }

    static void resetReady(long jobId, Job job, int seconds) {
        String remark = JobState.getRemark(job);
        String param = job.getParam();
        String param_tag = null;
        if (param.length() > 127) {
            param_tag = param = StringUtil.trim((String)param, (int)80);
        }
        Timestamp delay = new Timestamp(System.currentTimeMillis() + (long)Math.max(seconds * 1000, 100));
        String sql = "UPDATE t_isc_job_inst SET fremark=?, fparam=?, fparam_tag=?, fstate='READY',fscheduled_time=?, fmodified_time=?, fend_time=? WHERE fid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        JobState.executeSql(sql, Arrays.asList(remark, param, param_tag, delay, now, now, jobId), Arrays.asList(12, 12, 12, 93, 93, 93, -5));
    }

    static void delete(long jobId) {
        String sql = "DELETE FROM t_isc_job_inst WHERE fid=?";
        JobState.executeSql(sql, Collections.singletonList(jobId), Collections.singletonList(-5));
    }

    static void setProgress(long jobId, String progress) {
        progress = progress == null ? " " : StringUtil.trim((String)progress, (int)666);
        String sql = "UPDATE t_isc_job_inst SET fremark=?, fmodified_time=? WHERE fid=? AND fstate='RUNNING'";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        JobState.executeSql(sql, Arrays.asList(progress, now, jobId), Arrays.asList(12, 93, -5));
    }

    static boolean resetInterruptedJobs() {
        long now = System.currentTimeMillis();
        Timestamp timeout_low = new Timestamp(now - 172800000L);
        Timestamp timeout_high = new Timestamp(now - 600000L);
        String sql = "UPDATE t_isc_job_inst SET fstate='CREATED',fmodified_time=? WHERE fstate='RUNNING' and fmodified_time >=? and fmodified_time<=? ";
        List<Object> params = Arrays.asList(new Timestamp(now), timeout_low, timeout_high);
        List<Integer> types = Arrays.asList(93, 93, 93);
        return JobState.executeSql(sql, params, types);
    }

    static boolean resetFailedJob(long id) {
        long jobOwnerId = JobState.findJobOwnerId(id);
        if (jobOwnerId != 0L && JobState.getJobsWithOwnerId(jobOwnerId).size() > 0) {
            return false;
        }
        long now = System.currentTimeMillis();
        String sql = "UPDATE t_isc_job_inst SET fstate='CREATED',fmodified_time=? WHERE fstate='FAILED' and fid = ?";
        List<Object> params = Arrays.asList(new Timestamp(now), id);
        List<Integer> types = Arrays.asList(93, -5);
        return JobState.executeSql(sql, params, types);
    }

    static void dropJobByOwnerId(long ownerId) {
        String sql = "DELETE FROM t_isc_job_inst WHERE fjob_owner = ?";
        List<Object> params = Collections.singletonList(ownerId);
        List<Integer> types = Collections.singletonList(-5);
        JobState.executeSql(sql, params, types);
    }

    static boolean dropNoRunningJobByOwnerId(long ownerId) {
        String sql = "DELETE FROM t_isc_job_inst WHERE fjob_owner = ? AND  fstate IN('CREATED','WAITING','READY') ";
        List<Object> params = Collections.singletonList(ownerId);
        List<Integer> types = Collections.singletonList(-5);
        return JobState.executeSql(sql, params, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean existsJobWithOwnerId(long ownerId) {
        String sql = "SELECT COUNT(*) FROM t_isc_job_inst WHERE fjob_owner = ? AND  fstate IN('CREATED','WAITING','READY','RUNNING')";
        List<Long> params = Collections.singletonList(ownerId);
        List<Integer> types = Collections.singletonList(-5);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            int affacted = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, params, types));
            boolean bl = affacted > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean existsRunningJobWithOwnerId(long ownerId) {
        String sql = "SELECT COUNT(*) FROM t_isc_job_inst WHERE fjob_owner = ? AND  fstate = 'RUNNING'";
        List<Long> params = Collections.singletonList(ownerId);
        List<Integer> types = Collections.singletonList(-5);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            int affacted = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, params, types));
            boolean bl = affacted > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static List<JobInfo> getAllJobsWithOwnerId(long ownerId) {
        String sql = "SELECT fid,fstate,ftype,ftitle FROM t_isc_job_inst WHERE fjob_owner = ?  ORDER BY fend_time DESC";
        return JobState.getJobs(ownerId, sql);
    }

    public static List<JobInfo> getJobsWithOwnerId(long ownerId) {
        String sql = "SELECT fid,fstate,ftype,ftitle FROM t_isc_job_inst WHERE fjob_owner = ? AND  fstate IN('CREATED','WAITING','READY','RUNNING') ORDER BY fend_time DESC";
        return JobState.getJobs(ownerId, sql);
    }

    public static List<JobInfo> getCreatedJobsWithOwnerId(long ownerId) {
        String sql = "SELECT fid,fstate,ftype,ftitle FROM t_isc_job_inst WHERE fjob_owner = ? AND  fstate = 'CREATED'";
        return JobState.getJobs(ownerId, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<JobInfo> getJobs(long ownerId, String sql) {
        List<Long> params = Collections.singletonList(ownerId);
        List<Integer> types = Collections.singletonList(-5);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            ArrayList<JobInfo> jobs = new ArrayList<JobInfo>(1);
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, params, types)) {
                long id = D.l((Object)row.get((Object)"fid"));
                JobState state = JobState.valueOf((String)row.get((Object)"fstate"));
                JobFactory factory = JobEngine.getFactory((String)row.get((Object)"ftype"));
                String title = (String)row.get((Object)"ftitle");
                jobs.add(new JobInfo(id, state, title, factory));
            }
            ArrayList<JobInfo> arrayList = jobs;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findJobOwnerId(long id) {
        List<Long> params = Collections.singletonList(id);
        List<Integer> types = Collections.singletonList(-5);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            Object o = DbUtil.executeScalar((Connection)cn, (String)"SELECT fjob_owner FROM t_isc_job_inst WHERE fid = ?", params, types);
            long l = D.l((Object)o);
            return l;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsNextJob(long ownerId, Timestamp scheduledTime) {
        String sql = "SELECT COUNT(*) FROM t_isc_job_inst  WHERE fjob_owner = ? AND fscheduled_time = ? AND fstate IN('CREATED','WAITING','READY')";
        List params = D.asList((Object[])new Object[]{ownerId, scheduledTime});
        List types = D.asList((Object[])new Integer[]{-5, 93});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            int count = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, (List)params, (List)types));
            boolean bl = count > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    static {
        logger = LogFactory.getLog(JobState.class);
    }
}

