/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job.c;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.isc.iscb.platform.core.job.JobMutex;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class JobMutexLoader
implements DaemonTask {
    private final String id = UUID.randomUUID().toString();
    private static final Map<String, Map<String, DLock>> ALL_LOCKS = new ConcurrentHashMap<String, Map<String, DLock>>();
    private static Log logger = LogFactory.getLog(JobMutexLoader.class);

    public static void refreshAll() {
        RequestContext ctx = RequestContext.get();
        String tenantId = ctx.getTenantId();
        String accountId = ctx.getAccountId();
        JobMutexLoader.mqRefresh(tenantId, accountId);
        Object[] params = new Object[]{tenantId, accountId};
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)JobMutexLoader.class.getName(), (String)"mqRefresh", (Object[])params);
    }

    public static void mqRefresh(String tenantId, String accountId) {
        RequestContext ctx = ContextUtil.createRequestContext(accountId, tenantId);
        int delay = (int)(System.currentTimeMillis() % 7L) + 1;
        ScheduleManager.submit((Task)new JobMutexLoader(), ctx, delay);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void run() {
        HashMap<Long, Integer> counterMap = new HashMap<Long, Integer>();
        int releasedMutexInsCount = this.applyGlobalMutexInstances(counterMap);
        this.applyLocalMutexInstances(counterMap);
        if (releasedMutexInsCount > 0) {
            JobMutexLoader.refreshAll();
        }
        JobMutex.refresh(counterMap);
    }

    private void applyLocalMutexInstances(Map<Long, Integer> counterMap) {
        List<DataRow> mutexes = this.queryLocalMutexes();
        for (DataRow row : mutexes) {
            Long mutexId = D.l((Object)row.get((Object)"fid"));
            int maxThreads = this.getMaxThreads(row);
            counterMap.put(mutexId, maxThreads);
        }
    }

    private int getMaxThreads(DataRow row) {
        if (this.isExecutableOnThisServer(row)) {
            return Math.max(1, D.i((Object)row.get((Object)"fmax_threads")));
        }
        return 0;
    }

    private boolean isExecutableOnThisServer(DataRow row) {
        String appid = D.s((Object)row.get((Object)"fappid"));
        if (appid == null) {
            return true;
        }
        if ("*".equals(appid)) {
            return true;
        }
        String[] appIds = Instance.getAppIds();
        if (appIds != null) {
            for (String s : appIds) {
                if (!appid.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return appid.equals(System.getProperty("ISC_JOB_ENGINE_APP_ID"));
    }

    static String getAppIds() {
        String appIds = StringUtil.join((Object[])Instance.getAppIds());
        String tmp = System.getProperty("ISC_JOB_ENGINE_APP_ID");
        return appIds + ";" + tmp;
    }

    private int applyGlobalMutexInstances(Map<Long, Integer> counterMap) {
        List<DataRow> mutexInstances = this.queryGlobalMutexInstances();
        final String currentServerIns = TaskManager.getInstanceId();
        Collections.sort(mutexInstances, new Comparator<DataRow>(){

            @Override
            public int compare(DataRow rowa, DataRow rowb) {
                int a = D.i((Object)rowa.get((Object)"fseq")) + (currentServerIns.equals(rowa.get((Object)"finstance")) ? 0 : 1000000000);
                int b = D.i((Object)rowb.get((Object)"fseq")) + (currentServerIns.equals(rowb.get((Object)"finstance")) ? 0 : 1000000000);
                return Integer.compare(a, b);
            }
        });
        int serverInstanceCount = this.queryInstanceCount();
        int maxMutexInsCount = Math.max(1, (int)Math.ceil((double)mutexInstances.size() / (double)serverInstanceCount));
        int occupiedMutexInsCount = 0;
        int releasedMutexInsCount = 0;
        for (DataRow row : mutexInstances) {
            Long mutexId = D.l((Object)row.get((Object)"fid"));
            counterMap.putIfAbsent(mutexId, 0);
            if (occupiedMutexInsCount < maxMutexInsCount) {
                occupiedMutexInsCount = this.tryOccupyMutexInstance(row, counterMap, mutexId, currentServerIns, occupiedMutexInsCount);
                continue;
            }
            releasedMutexInsCount = this.tryReleaseMutexInstance(row, currentServerIns, releasedMutexInsCount);
        }
        return releasedMutexInsCount;
    }

    private int tryReleaseMutexInstance(DataRow row, String currentServerIns, int releasedMutexInsCount) {
        if (JobMutexLoader.unlock(row)) {
            ++releasedMutexInsCount;
            if (currentServerIns.equals(row.get((Object)"finstance"))) {
                this.setUnoccupied(row);
            }
        }
        return releasedMutexInsCount;
    }

    private int tryOccupyMutexInstance(DataRow row, Map<Long, Integer> counterMap, Long mutexId, String currentServerIns, int occupiedMutexInsCount) {
        if (JobMutexLoader.lock(row)) {
            ++occupiedMutexInsCount;
            counterMap.put(mutexId, counterMap.get(mutexId) + 1);
            if (!currentServerIns.equals(row.get((Object)"finstance"))) {
                this.setOccupied(row, currentServerIns);
            }
        }
        return occupiedMutexInsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUnoccupied(DataRow row) {
        String sql = "UPDATE t_isc_job_mutex_instance SET finstance = ' ', fip = ' ', flast_modified_time= null,foccupied_time=null WHERE fentryid=?";
        List<Object> params = Collections.singletonList(row.get((Object)"fentryid"));
        List<Integer> types = Collections.singletonList(-5);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, params, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOccupied(DataRow row, String currentInstanceId) {
        String sql = "UPDATE t_isc_job_mutex_instance SET finstance = ?, fip=?, flast_modified_time=?,foccupied_time=? WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String fip = NetUtil.getServerId();
        List<Object> params = Arrays.asList(currentInstanceId, fip, now, now, row.get((Object)"fentryid"));
        List<Integer> types = Arrays.asList(12, 12, 93, 93, -5);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, params, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryInstanceCount() {
        String cluster = TaskManager.getClusterId();
        String sql = "SELECT count(*) AS c FROM T_ISCB_SERVER_INSTANCE where finstance_id LIKE ? and fis_online='1'";
        List<String> params = Collections.singletonList("%@" + cluster);
        List<Integer> types = Collections.singletonList(12);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            int n = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, params, types));
            return n;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataRow> queryGlobalMutexInstances() {
        String sql = "SELECT fentryid, fid, fseq, finstance FROM t_isc_job_mutex_instance ORDER BY fseq";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            return list;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataRow> queryLocalMutexes() {
        String sql = "SELECT fid, fmax_threads, fappid FROM t_isc_job_mutex WHERE fscope = 'LOCAL'";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            return list;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private static boolean lock(DataRow row) {
        String key;
        Map<String, DLock> locks = JobMutexLoader.getLockContainer();
        if (locks.containsKey(key = JobMutexLoader.generateKey(row))) {
            return true;
        }
        DLock dlock = DLock.create((String)key);
        if (dlock.tryLock()) {
            locks.put(key, dlock);
            return true;
        }
        dlock.close();
        return false;
    }

    private static boolean unlock(DataRow row) {
        String key;
        Map<String, DLock> locks = JobMutexLoader.getLockContainer();
        DLock dlock = locks.remove(key = JobMutexLoader.generateKey(row));
        if (dlock == null) {
            return false;
        }
        dlock.close();
        return true;
    }

    private static String generateKey(DataRow row) {
        return "isc/job/mutex/" + RequestContext.get().getAccountId() + "/" + row.get((Object)"fentryid");
    }

    private static synchronized Map<String, DLock> getLockContainer() {
        String accountId = RequestContext.get().getAccountId();
        Map<String, DLock> locks = ALL_LOCKS.get(accountId);
        if (locks == null) {
            locks = new ConcurrentHashMap<String, DLock>();
            ALL_LOCKS.put(accountId, locks);
        }
        return locks;
    }

    public static void clear() {
        RequestContext ctx = RequestContext.get();
        String key = ctx.getAccountId();
        Map<String, DLock> map = ALL_LOCKS.remove(key);
        if (map != null) {
            for (DLock m : map.values()) {
                try {
                    m.close();
                }
                catch (Throwable e) {
                    logger.warn("\u5173\u95ed\u5206\u5e03\u5f0f\u9501\u53d1\u751f\u5f02\u5e38,lock=" + m, e);
                }
            }
        }
    }
}

