/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.job.c;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.c.JobMutexLoader;
import kd.isc.iscb.platform.core.task.DaemonTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class JobServerMonitor
implements DaemonTask {
    private int serverCount;
    private String id = UUID.randomUUID().toString();
    private static Log logger = LogFactory.getLog(DataCopyTask.class);

    @Override
    public void run() {
        try {
            int serverCount = this.scanMembers();
            this.notifyJobMutexLoader(serverCount);
            this.serverCount = serverCount;
        }
        catch (Throwable e) {
            logger.warn("data_copy_cluster_monitor_failed.", e);
        }
        finally {
            ScheduleManager.submit((Task)this, 1200);
        }
    }

    private void notifyJobMutexLoader(int serverCount) {
        if (this.clearTimeoutJobMutexInstances()) {
            JobMutexLoader.refreshAll();
        } else if (serverCount != this.serverCount) {
            JobMutexLoader.refreshAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearTimeoutJobMutexInstances() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            String sql = "UPDATE t_isc_job_mutex_instance SET finstance = ' ', fip = ' ', flast_modified_time = null, foccupied_time = null WHERE flast_modified_time < ?";
            int affected = DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(new Timestamp(this.calcDeadline())), Collections.singletonList(93));
            boolean bl = affected > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private int scanMembers() {
        long deadline = this.calcDeadline();
        String master = TaskManager.getInstanceId();
        int count = 0;
        for (DataRow item : this.loadMembers()) {
            String instanceId = D.s((Object)item.get((Object)"finstance_id"));
            if (D.t((Object)item.get((Object)"flast_modified_time")).getTime() < deadline) {
                this.doSetAsOffline(instanceId);
                continue;
            }
            master = this.selectMaster(master, instanceId);
            ++count;
        }
        JobEngine.setMaster(master);
        return count;
    }

    private long calcDeadline() {
        return System.currentTimeMillis() - 2400000L;
    }

    private String selectMaster(String master, String instanceId) {
        if (instanceId.compareTo(master) > 0) {
            master = instanceId;
        }
        return master;
    }

    private void doSetAsOffline(String instanceId) {
        try {
            if (this.setAsOffLine(instanceId)) {
                JobEngine.notify(System.currentTimeMillis() + 5000L);
            }
        }
        catch (Throwable e) {
            logger.warn("reset_inative_member_failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataRow> loadMembers() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "SELECT finstance_id,flast_modified_time FROM T_ISCB_SERVER_INSTANCE  WHERE fis_online = '1'";
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            return list;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setAsOffLine(String instanceId) throws SQLException {
        boolean changed;
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        try {
            String sql = "UPDATE T_ISCB_SERVER_INSTANCE SET fis_online='0' WHERE fis_online='1' AND finstance_id=?";
            changed = DbUtil.executeUpdate((Connection)cn, (String)sql, Collections.singletonList(instanceId), Collections.singletonList(12)) > 0;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        return changed;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

