/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.Rsa;
import kd.isc.iscb.util.script.encoding.Encoding;
import kd.isc.iscb.util.script.encoding.Hash;

public class GrayFeatureUtil {
    private static final Map<Pair<String, String>, Pair<State, Long>> cache = new ReadLockFreeMap();

    public static String generateEnvSign(String feature_number) {
        RequestContext ctx = RequestContext.get();
        String s = ctx.getTenantCode() + "\r\n" + ctx.getAccountId() + "\r\n" + feature_number;
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        byte[] md5 = Hash.md5((byte[])bytes);
        byte[] base64 = Encoding.BASE64.encode(md5);
        return new String(base64, StandardCharsets.UTF_8);
    }

    public static void showApplyFormWhenNoLicense(AbstractFormPlugin appHomePage, String feature_number, String feature_name) {
        GrayFeatureUtil.showApplyFormWhenNoLicense(appHomePage, feature_number, feature_name, null);
    }

    public static void showApplyFormWhenNoLicense(AbstractFormPlugin appHomePage, String feature_number, String feature_name, String caption) {
        if (GrayFeatureUtil.getLicenseState(feature_number) != State.S) {
            GrayFeatureUtil.showGrayFeatureApplyForm(appHomePage, feature_number, feature_name, caption);
        }
    }

    public static void showGrayFeatureApplyForm(AbstractFormPlugin appHomePage, String feature_number, String feature_name) {
        GrayFeatureUtil.showGrayFeatureApplyForm(appHomePage, feature_number, feature_name, null);
    }

    public static void showGrayFeatureApplyForm(AbstractFormPlugin appHomePage, String feature_number, String feature_name, String caption) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("feature_number", feature_number);
        params.put("feature_name", feature_name);
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_gray_feature_apply");
        p.setCustomParams(params);
        p.getOpenStyle().setShowType(ShowType.Modal);
        if (caption != null) {
            p.setCaption(caption);
        }
        appHomePage.getView().showForm(p);
    }

    public static Date saveLicense(String feature_number, String license_content) {
        Pair<String, Timestamp> license = GrayFeatureUtil.parseLicense(license_content);
        if (!Objects.equals(license.getKey(), GrayFeatureUtil.generateEnvSign(feature_number))) {
            return null;
        }
        GrayFeatureUtil.saveLicenseContent(feature_number, license, license_content);
        GrayFeatureUtil.clearCache();
        return (Date)license.getValue();
    }

    private static Pair<String, Timestamp> parseLicense(String license_content) {
        Timestamp expiredTimestamp;
        if (license_content == null || license_content.length() < 40) {
            String s = ResManager.loadKDString((String)"\u8bb8\u53ef\u5185\u5bb9\u4e0d\u5408\u6cd5\u3002", (String)"GrayFeatureUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(s);
        }
        String t = Rsa.decrypt((String)license_content, (String)"8279870512416623814331406854743365863417800100708630777184060680516456074384236519194164444309831899126368055389363566528516619305791116595413197898720351,65537");
        int i = t.indexOf(44);
        if (i <= 0) {
            String s = ResManager.loadKDString((String)"\u8bb8\u53ef\u5185\u5bb9\u5f02\u5e38\u3002", (String)"GrayFeatureUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(s);
        }
        String license_sign = t.substring(0, i);
        String expired_time = t.substring(i + 1);
        try {
            expiredTimestamp = D.t((Object)(expired_time + " 23:59:59.999"));
        }
        catch (Throwable throwable) {
            String s = ResManager.loadKDString((String)"\u8bb8\u53ef\u5185\u5bb9\u4e0d\u5408\u6cd5\u3002", (String)"GrayFeatureUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(s, throwable);
        }
        Pair license = new Pair((Object)license_sign, (Object)expiredTimestamp);
        return license;
    }

    private static void saveLicenseContent(String feature_number, Pair<String, Timestamp> license, String license_content) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"isc_gray_feature", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)feature_number)});
        obj = obj == null ? BusinessDataServiceHelper.newDynamicObject((String)"isc_gray_feature") : BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)"isc_gray_feature");
        RequestContext ctx = RequestContext.get();
        obj.set("number", (Object)feature_number);
        obj.set("tenant", (Object)ctx.getTenantCode());
        obj.set("account", (Object)ctx.getAccountId());
        obj.set("env_sign", license.getKey());
        obj.set("creator_id", (Object)ctx.getCurrUserId());
        obj.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        obj.set("state", (Object)"S");
        obj.set("expired_time", license.getValue());
        obj.set("license_content", (Object)license_content);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    public static void checkLicenseState(String feature_number) {
        IscBizException e;
        State state = GrayFeatureUtil.getLicenseState(feature_number);
        if (State.S == state) {
            return;
        }
        switch (state) {
            case N: {
                String s = ResManager.loadKDString((String)"\u6ca1\u6709\u7070\u5ea6\u7279\u6027\u8bb8\u53ef\u3002", (String)"GrayFeatureUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                e = new IscBizException(s);
                break;
            }
            case X: {
                String s = ResManager.loadKDString((String)"\u8be5\u5bc6\u94a5\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7\u5bc6\u94a5", (String)"GrayFeatureUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                e = new IscBizException(s);
                break;
            }
            case X1: {
                String s = ResManager.loadKDString((String)"\u7070\u5ea6\u7279\u6027\u8bb8\u53ef\u4e0d\u5408\u6cd5\uff0c\u9700\u8981\u91cd\u65b0\u7533\u8bf7\u3002", (String)"GrayFeatureUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                e = new IscBizException(s);
                break;
            }
            case X2: {
                String s = ResManager.loadKDString((String)"\u7070\u5ea6\u7279\u6027\u8bb8\u53ef\u4e0e\u5f53\u524d\u8d26\u5957\u4e0d\u7b26\uff0c\u9700\u8981\u91cd\u65b0\u7533\u8bf7\u3002", (String)"GrayFeatureUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                e = new IscBizException(s);
                break;
            }
            case X3: {
                String s = ResManager.loadKDString((String)"\u7070\u5ea6\u7279\u6027\u8bb8\u53ef\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u7b26\uff0c\u9700\u8981\u91cd\u65b0\u7533\u8bf7\u3002", (String)"GrayFeatureUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                e = new IscBizException(s);
                break;
            }
            case X4: {
                String s = ResManager.loadKDString((String)"\u7070\u5ea6\u7279\u6027\u8bb8\u53ef\u7684\u7279\u5f81\u7801\u4e0e\u5f53\u524d\u73af\u5883\u4e0d\u7b26\uff0c\u9700\u8981\u91cd\u65b0\u7533\u8bf7\u3002", (String)"GrayFeatureUtil_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                e = new IscBizException(s);
                break;
            }
            default: {
                String s = ResManager.loadKDString((String)"\u975e\u6cd5\u72b6\u6001\uff1a%s", (String)"GrayFeatureUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                e = new IscBizException(String.format(s, new Object[]{state}));
            }
        }
        e.setStackTrace(new StackTraceElement[0]);
        throw e;
    }

    public static State getLicenseState(String feature_number) {
        State state;
        Pair key = new Pair((Object)RequestContext.get().getAccountId(), (Object)feature_number);
        Pair<State, Long> license = cache.get(key);
        if (license == null) {
            license = GrayFeatureUtil.loadLicense(feature_number);
            cache.put((Pair<String, String>)key, license);
        }
        if ((state = (State)((Object)license.getKey())) == State.S) {
            state = GrayFeatureUtil.checkDeadline(state, (Pair<String, String>)key, license);
        }
        return state;
    }

    public static void refreshLicenseState(String feature_number) {
        Pair<State, Long> license = GrayFeatureUtil.loadLicense(feature_number);
        State state = GrayFeatureUtil.getLicenseState(feature_number);
        if (state != license.getKey()) {
            GrayFeatureUtil.clearCache();
        }
    }

    private static void clearCache() {
        cache.clear();
        BroadcastService.broadcastMessageWithApp((String)"iscb", (String)GrayFeatureUtil.class.getName(), (String)"mqClearCache", (Object[])new String[0]);
    }

    private static State checkDeadline(State state, Pair<String, String> key, Pair<State, Long> license) {
        if (System.currentTimeMillis() > (Long)license.getValue()) {
            state = State.X;
            cache.remove(key);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<State, Long> loadLicense(String feature_number) {
        RequestContext ctx = RequestContext.get();
        if (",tenant_devother_smoke,tenant_patchother_smoke,baseline_smoke,".contains("," + ctx.getTenantCode() + ",")) {
            return new Pair((Object)State.S, (Object)Long.MAX_VALUE);
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DataRow row = GrayFeatureUtil.loadLicense(feature_number, cn);
            if (row == null) {
                Pair pair = new Pair((Object)State.N, (Object)0L);
                return pair;
            }
            String dbState = D.s((Object)row.get((Object)"fstate"));
            Pair<State, Long> license = GrayFeatureUtil.parseLicense(row, feature_number, dbState);
            String state = ((State)((Object)license.getKey())).name();
            if (!state.equals(dbState)) {
                String sql = "UPDATE t_isc_gray_feature SET fstate=? WHERE fnumber=?";
                DbUtil.executeUpdate((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{state, feature_number}), (List)D.asList((Object[])new Integer[]{12, 12}));
            }
            Pair<State, Long> pair = license;
            return pair;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static DataRow loadLicense(String feature_number, Connection cn) {
        String sql = "SELECT fid,ftenant,faccount,fenv_sign,fstate,fexpired_time,flicense_content FROM t_isc_gray_feature WHERE fnumber=?";
        return DbUtil.executeRow((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{feature_number}), (List)D.asList((Object[])new Integer[]{12}));
    }

    private static Pair<State, Long> parseLicense(DataRow row, String feature_number, String state) {
        try {
            RequestContext ctx = RequestContext.get();
            if (!row.get((Object)"ftenant").equals(ctx.getTenantCode()) || !row.get((Object)"faccount").equals(ctx.getAccountId())) {
                return new Pair((Object)State.X2, (Object)0L);
            }
            String envSign = GrayFeatureUtil.generateEnvSign(feature_number);
            if (!envSign.equals(row.get((Object)"fenv_sign"))) {
                return new Pair((Object)State.X3, (Object)0L);
            }
            Pair<String, Timestamp> license = GrayFeatureUtil.parseLicense(D.s((Object)row.get((Object)"flicense_content")));
            if (!envSign.equals(license.getKey())) {
                return new Pair((Object)State.X4, (Object)0L);
            }
            long deadline = ((Timestamp)license.getValue()).getTime();
            if (System.currentTimeMillis() > deadline) {
                return new Pair((Object)State.X, (Object)deadline);
            }
            return new Pair((Object)State.S, (Object)deadline);
        }
        catch (Exception e) {
            return new Pair((Object)State.X1, (Object)0L);
        }
    }

    public static void mqClearCache() {
        cache.clear();
    }

    public static enum State {
        N,
        S,
        X,
        X1,
        X2,
        X3,
        X4;

    }
}

