/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license.n;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionState;
import kd.isc.iscb.platform.core.license.n.GroupCategory;

public class GroupInfo {
    private GroupCategory category;
    private AccountInfo account;
    private int usedLicenseCount;
    private int lastLicenseSN = -1;
    private Map<Long, ConnectionInfo> connections = new LinkedHashMap<Long, ConnectionInfo>();

    public GroupInfo(AccountInfo account, GroupCategory category) {
        this.category = category;
        this.account = account;
        this.usedLicenseCount = 0;
    }

    public GroupCategory getCategory() {
        return this.category;
    }

    public AccountInfo getAccount() {
        return this.account;
    }

    public int getUsedLicenseCount() {
        return this.usedLicenseCount;
    }

    public int getFreeConnectionCount() {
        ConnectionState target = ConnectionState.free;
        return this.count(target);
    }

    public int getWithoutLicenseConnectionCount() {
        ConnectionState target = ConnectionState.no;
        return this.count(target);
    }

    public int getWithLicenseConnectionCount() {
        ConnectionState target = ConnectionState.yes;
        return this.count(target);
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    private int count(ConnectionState target) {
        int count = 0;
        for (ConnectionInfo cn : this.connections.values()) {
            if (cn.getState() != target) continue;
            ++count;
        }
        return count;
    }

    void addConnection(long id, String type, String number, String name, Date createTime) {
        ConnectionState state = this.calcState(type, createTime);
        int licenseSN = state == ConnectionState.yes ? this.lastLicenseSN : 0;
        ConnectionInfo cn = new ConnectionInfo(id, type, number, name, state, createTime, licenseSN, this);
        this.connections.put(id, cn);
    }

    public Map<Long, ConnectionInfo> getConnections() {
        return Collections.unmodifiableMap(this.connections);
    }

    private ConnectionState calcState(String type, Date createTime) {
        if (this.category.isFree(type)) {
            return ConnectionState.free;
        }
        if (createTime == null) {
            return ConnectionState.no;
        }
        if (this.deductLicense()) {
            return ConnectionState.yes;
        }
        return ConnectionState.no;
    }

    private boolean deductLicense() {
        if (this.usedLicenseCount < this.category.maxLicenseBudgetCount(this)) {
            int sn = this.account.getTenant().deductLicense();
            if (sn < 0) {
                return false;
            }
            this.lastLicenseSN = sn;
            ++this.usedLicenseCount;
            return true;
        }
        return true;
    }

    public ConnectionInfo getSystemConnection(long connectionId) {
        if (this.category.isMQ()) {
            return null;
        }
        return this.connections.get(connectionId);
    }

    public ConnectionInfo getMqConnection(long connectionId) {
        if (this.category.isMQ()) {
            return this.connections.get(connectionId);
        }
        return null;
    }
}

