/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license.n;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.GroupInfo;
import kd.isc.iscb.platform.core.license.n.LicenseKey;
import kd.isc.iscb.platform.core.license.n.LicenseTask;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;

public class LicenseCache {
    private static final String ACCOUNT_NUMBER = "accountNumber";
    private static final String DATABASE_TYPE = "database_type";
    private static final String ACCOUNT_ID = "accountId";
    private static final String ACCOUNT_NAME = "accountName";
    private static final String IS_MQ = "isMQ";
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ID_CREATETIME_TYPE_NUMBER_NAME = "id,createtime,type,number,name";
    private static final String ID_CREATETIME_DATABASE_TYPE_NUMBER_NAME = "id,createtime,database_type,number,name";
    private static final String CREATE_TIME = "createtime";
    private static final Map<LicenseKey, TenantInfo> tenants = new ReadLockFreeMap();

    public static TenantInfo getTenant() {
        LicenseKey key = new LicenseKey(RequestContext.get());
        TenantInfo tenant = tenants.get(key);
        if (tenant == null) {
            tenant = LicenseCache.createTenant(true);
            tenants.put(key, tenant);
        }
        return tenant;
    }

    public static TenantInfo refreshTenant() {
        LicenseKey key = new LicenseKey(RequestContext.get());
        TenantInfo tenant = LicenseCache.createTenant(true);
        tenants.put(key, tenant);
        return tenant;
    }

    public static TenantInfo refreshTenant2() {
        LicenseKey key = new LicenseKey(RequestContext.get());
        TenantInfo tenant = LicenseCache.createTenant(false);
        tenants.put(key, tenant);
        return tenant;
    }

    public static void asyncRefreshTenant() {
        LightTaskManager.submit(new LightTask(){
            private String id = UUID.randomUUID().toString();

            @Override
            public String getId() {
                return this.id;
            }

            @Override
            public void run() {
                LicenseCache.refreshTenant2();
            }
        });
    }

    public static void refreshTenantForMQ(String tenant, String account) {
        RequestContext ctx = ContextUtil.createRequestContext(account, tenant);
        RequestContextCreator.restoreForMQ((RequestContext)ctx);
        LicenseCache.asyncRefreshTenant();
    }

    public static void clear() {
        tenants.clear();
    }

    private static TenantInfo createTenant(boolean forceRefresh) {
        List<Map<String, Object>> list = LicenseCache.loadAllConnections();
        TenantInfo tenant = new TenantInfo(LicenseTask.getTask(forceRefresh));
        for (Map<String, Object> item : list) {
            String accountId = (String)item.get(ACCOUNT_ID);
            String accountName = (String)item.get(ACCOUNT_NAME);
            AccountInfo c = tenant.getOrCreateAccount(accountId, accountName);
            boolean isMQ = (Boolean)item.get(IS_MQ);
            String type = (String)item.get(TYPE);
            GroupInfo group = c.getOrCreateGroup(type, isMQ);
            long id = (Long)item.get(ID);
            String number = (String)item.get(NUMBER);
            String name = (String)item.get(NAME);
            Timestamp createTime = D.t((Object)item.get(CREATE_TIME));
            group.addConnection(id, type, number, name, createTime);
        }
        return tenant;
    }

    private static List<Map<String, Object>> loadAllConnections() {
        List<Map<String, Object>> list = LicenseCache.loadConnections();
        list.sort(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                long a = D.l((Object)o1.get(LicenseCache.CREATE_TIME));
                long b = D.l((Object)o2.get(LicenseCache.CREATE_TIME));
                return Long.compare(a, b);
            }
        });
        return list;
    }

    private static List<Map<String, Object>> loadConnections() {
        RequestContext ctx = RequestContext.get();
        Account c = AccountUtils.getAccountById((String)ctx.getAccountId());
        DynamicObject[] isc_database_links = BusinessDataServiceHelper.load((String)"isc_database_link", (String)ID_CREATETIME_DATABASE_TYPE_NUMBER_NAME, null);
        DynamicObject[] isc_mq_servers = BusinessDataServiceHelper.load((String)"isc_mq_server", (String)ID_CREATETIME_TYPE_NUMBER_NAME, null);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(isc_database_links.length + isc_mq_servers.length);
        for (DynamicObject object : isc_database_links) {
            list.add(LicenseCache.toMap(c, object, false));
        }
        for (DynamicObject object : isc_mq_servers) {
            list.add(LicenseCache.toMap(c, object, true));
        }
        return list;
    }

    private static Map<String, Object> toMap(Account c, DynamicObject obj, boolean isMQ) {
        LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
        item.put(ID, D.l((Object)obj.getPkValue()));
        item.put(TYPE, obj.getString(isMQ ? TYPE : DATABASE_TYPE));
        item.put(NUMBER, obj.getString(NUMBER));
        item.put(NAME, obj.getString(NAME));
        item.put(ACCOUNT_ID, c.getAccountId());
        item.put(ACCOUNT_NUMBER, c.getAccountNumber());
        item.put(ACCOUNT_NAME, c.getAccountName());
        item.put(IS_MQ, isMQ);
        item.put(CREATE_TIME, obj.get(CREATE_TIME));
        return item;
    }
}

