/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license.n;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.license.n.LicenseKey;
import kd.isc.iscb.platform.core.license.n.MCLicenseUtil;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.ScheduleManager;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;

final class LicenseTask
implements LightTask {
    private final String id = UUID.randomUUID().toString();
    private LicenseKey key;
    private String version;
    private String expiredDate;
    private int licenseCount = 0;
    private String fileType;
    private Map<String, Object> productInfoFromMC;
    private boolean iscx_enabled;
    private boolean iscb_enabled;
    private int resourceLicenseCount = 0;
    private int mode = 3;
    private int mainVersion;
    private static final Map<LicenseKey, LicenseTask> tasks = new ReadLockFreeMap();
    private static final Log logger = LogFactory.getLog(LicenseTask.class);

    private LicenseTask(LicenseKey key) {
        this.key = key;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public LicenseKey getKey() {
        return this.key;
    }

    public boolean iscxEnabled() {
        return this.iscx_enabled;
    }

    public boolean iscbEnabled() {
        return this.iscb_enabled;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExpiredDate() {
        return this.expiredDate;
    }

    public int getLicenseCount() {
        return this.licenseCount;
    }

    public int getResourceLicenseCount() {
        return this.resourceLicenseCount;
    }

    public String getFileType() {
        return this.fileType;
    }

    public int getLicenseMode() {
        return this.mode;
    }

    public String toString() {
        return "LicenseTask: " + this.key;
    }

    @Override
    public void run() {
        if (tasks.get(this.key) == this) {
            try {
                this.refreshLicense();
                this.refreshTenant();
            }
            catch (Throwable e) {
                logger.warn("\u5237\u65b0\u8bb8\u53ef\u4fe1\u606f\u5931\u8d25", e);
            }
            this.submit(1800);
        }
    }

    private void refreshTenant() {
        TenantInfo tenant = LicenseCache.getTenant();
        if (!this.expiredDate.equals(tenant.getExpiredDate()) || this.licenseCount != tenant.getTotalLicenseCount()) {
            LicenseCache.refreshTenant2();
        }
    }

    private void submit(int seconds) {
        ScheduleManager.submit((Task)this, seconds);
    }

    private void refreshLicense() {
        this.refreshLicenseInfoFromMC();
        this.refreshVersion();
        this.refreshLicenseCount();
        this.refreshProductInfo();
        this.refreshIscxLicense();
        this.refreshIscbLicense();
        this.refreshResourceLicenseCount();
    }

    private void refreshIscxLicense() {
        if (this.mainVersion <= 6) {
            LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_ISCX");
            this.iscx_enabled = result.getHasLicense();
        } else {
            LicenseCheckResult result = LicenseServiceHelper.checkLicenseModules((String)"PRO_ISCX");
            this.iscx_enabled = result.getHasLicense();
        }
    }

    private void refreshIscbLicense() {
        if (this.mainVersion <= 6) {
            LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_ISCB");
            this.iscb_enabled = result.getHasLicense();
        } else {
            LicenseCheckResult result = LicenseServiceHelper.checkLicenseModules((String)"PRO_ISCB");
            this.iscb_enabled = result.getHasLicense();
        }
    }

    private void refreshLicenseInfoFromMC() {
        this.productInfoFromMC = MCLicenseUtil.getProductInfo();
        if (this.productInfoFromMC == null) {
            this.productInfoFromMC = Collections.emptyMap();
        }
    }

    private void refreshProductInfo() {
        Map productInfo = LicenseServiceHelper.getProductInfo();
        logger.info("LicenseServiceHelper.getProductInfo()\u8fd4\u56de\u503c: " + productInfo);
        if (productInfo != null) {
            String s = this.getExpdate(productInfo);
            this.expiredDate = s != null ? s : new Timestamp(System.currentTimeMillis() - 1000L).toString();
            String t = D.s(productInfo.get("type"));
            this.fileType = t != null ? t : ResManager.loadKDString((String)"\u672a\u77e5", (String)"LicenseTask_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        } else {
            this.expiredDate = new Timestamp(System.currentTimeMillis() - 1000L).toString();
            this.fileType = ResManager.loadKDString((String)"\u672a\u77e5", (String)"LicenseTask_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
    }

    private String getExpdate(Map<String, String> productInfo) {
        String s = D.s((Object)productInfo.get("expdate"));
        try {
            String t = D.s((Object)MCLicenseUtil.getExpireDate(this.productInfoFromMC));
            logger.info("MCLicenseUtil.getExpireDate\uff1a" + t);
            if (s == null) {
                return t;
            }
            if (t == null) {
                return s;
            }
            if (D.t((Object)t).after(D.t((Object)s))) {
                return t;
            }
            return s;
        }
        catch (Exception e) {
            logger.warn("\u4e0e\u4eceMC\u4e2d\u83b7\u53d6\u7684\u8fc7\u671f\u65f6\u95f4\u6bd4\u8f83\u5931\u8d25", (Throwable)e);
            return s;
        }
    }

    private void refreshLicenseCount() {
        int mode = this.mode = LicenseServiceHelper.getModeType();
        logger.info("LicenseServiceHelper.getModeType\u8fd4\u56de\u503c\u662f: " + mode);
        if (mode == 3 && "1.0".equals(this.version)) {
            int count = D.i((Object)System.getProperty("isc_license_count"));
            this.licenseCount = count <= 0 ? 10000 : count;
        } else {
            int i = LicenseServiceHelper.getTotalNumber((Object)41);
            int j = MCLicenseUtil.getLicenseNum(this.productInfoFromMC);
            this.licenseCount = Math.max(i, j);
            logger.info("LicenseServiceHelper.getTotalNumber\u8fd4\u56de\u503c\u662f: " + i + ", MC\u83b7\u53d6\u503c\u662f\uff1a" + j);
        }
    }

    private void refreshResourceLicenseCount() {
        this.resourceLicenseCount = 0;
    }

    private void refreshVersion() {
        String s = D.s((Object)LicenseServiceHelper.getProductVersion());
        logger.info("LicenseServiceHelper.getProductVersion\u8fd4\u56de\u503c: " + s);
        this.version = s != null ? s : "0.0";
        this.mainVersion = D.n((Object)this.version).intValue();
    }

    static LicenseTask getTask(boolean forceRefresh) {
        RequestContext ctx = RequestContext.get();
        LicenseKey key = new LicenseKey(ctx);
        LicenseTask task = tasks.get(key);
        if (task == null) {
            task = new LicenseTask(key);
            task.refreshLicense();
            tasks.put(key, task);
            task.submit(120);
        } else if (forceRefresh) {
            task.refreshLicense();
        }
        return task;
    }

    public static void clear() {
        tasks.clear();
    }
}

