/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.license.n;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.GroupCategory;
import kd.isc.iscb.platform.core.license.n.GroupInfo;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.util.misc.Pair;

public class TenantSnapshot {
    private static Log log = LogFactory.getLog(TenantSnapshot.class);
    private static Map<String, TenantSnapshot> snapshotMap = new ConcurrentHashMap<String, TenantSnapshot>();
    private String tenantId;
    private long snapshotTime;
    private Map<Pair<String, String>, List<ConnectionInfo>> accountConnections;

    private TenantSnapshot(String tenantId) {
        this.tenantId = tenantId;
    }

    public void printSnapshot() {
        long diff = System.currentTimeMillis() - this.snapshotTime;
        if (this.accountConnections == null || diff > 900000L) {
            this.accountConnections = this.initAccountConnectionList();
            this.snapshotTime = System.currentTimeMillis();
            snapshotMap.put(this.tenantId, this);
            log.info("\u5f53\u524d\u79df\u6237[" + this.tenantId + "]\u6240\u6709\u8fde\u63a5\u5feb\u7167\u4fe1\u606f\uff1a");
            for (Map.Entry<Pair<String, String>, List<ConnectionInfo>> entry : this.accountConnections.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(String.format(ResManager.loadKDString((String)"\u8d26\u5957%1$s\u7684\u8fde\u63a5\u4fe1\u606f", (String)"TenantSnapshot_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entry.getKey())).append('[');
                List<ConnectionInfo> connectionInfoList = entry.getValue();
                this.appendConnectionListInfo(sb, connectionInfoList);
                sb.append(']');
                log.info(sb.toString());
            }
        }
    }

    private void appendConnectionListInfo(StringBuilder sb, List<ConnectionInfo> connectionInfoList) {
        for (int i = 0; i < connectionInfoList.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            ConnectionInfo connInfo = connectionInfoList.get(i);
            sb.append("{'number':'").append(connInfo.getNumber()).append('\'').append(", 'licenseSN':'").append(connInfo.getLicenseSN()).append('\'').append(", 'state':'").append((Object)connInfo.getState()).append("'}");
        }
    }

    private Map<Pair<String, String>, List<ConnectionInfo>> initAccountConnectionList() {
        Map<String, AccountInfo> accounts = LicenseCache.getTenant().getAccounts();
        HashMap<Pair<String, String>, List<ConnectionInfo>> map = new HashMap<Pair<String, String>, List<ConnectionInfo>>(accounts.size());
        for (AccountInfo accountInfo : accounts.values()) {
            List<ConnectionInfo> connectionList = this.getConnectionInfos(accountInfo);
            map.put((Pair<String, String>)new Pair((Object)accountInfo.getAccountId(), (Object)accountInfo.getAccountName()), connectionList);
        }
        return map;
    }

    private List<ConnectionInfo> getConnectionInfos(AccountInfo accountInfo) {
        Map<GroupCategory, GroupInfo> groups = accountInfo.getGroups();
        ArrayList<ConnectionInfo> connectionList = new ArrayList<ConnectionInfo>(groups.size());
        for (GroupInfo groupInfo : groups.values()) {
            Map<Long, ConnectionInfo> connections = groupInfo.getConnections();
            connectionList.addAll(connections.values());
        }
        connectionList.sort(new Comparator<ConnectionInfo>(){

            @Override
            public int compare(ConnectionInfo o1, ConnectionInfo o2) {
                return o1.getLicenseSN() - o2.getLicenseSN();
            }
        });
        return connectionList;
    }

    public static TenantSnapshot getInstance() {
        String tenantId = RequestContext.get().getTenantId();
        TenantSnapshot tenantSnapshot = snapshotMap.get(tenantId);
        if (tenantSnapshot == null) {
            tenantSnapshot = new TenantSnapshot(tenantId);
            snapshotMap.put(tenantId, tenantSnapshot);
        }
        return tenantSnapshot;
    }

    private static void clearCache() {
        snapshotMap.clear();
    }
}

