/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.log;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.isc.iscb.platform.core.log.LogEnum;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class ClearLogUtil {
    private static final String STATE_RUNNING = "running";
    private static final int NUMBER = 10000;
    private static final int MAXLENGTH = 50;

    public static void handleQuery(Map<String, LogEnum> params, List<Object> range, boolean isAllState, IPageCache pageCache, AtomicInteger index) {
        if (pageCache == null || params == null || params.size() <= 0 || range == null) {
            return;
        }
        boolean single = range.size() == 1;
        for (Map.Entry<String, LogEnum> entry : params.entrySet()) {
            SignalManager.checkCancelSignal();
            long count = ClearLogUtil.queryLogs(entry.getValue(), range, isAllState, single);
            pageCache.put(entry.getValue().getMasterTable(), D.s((Object)count));
            index.incrementAndGet();
        }
    }

    public static void handleDelete(Map<String, LogEnum> params, List<Object> range, boolean isAllState, IPageCache pageCache, AtomicInteger index) {
        ClearLogUtil.updateRecord("aborted", ResManager.loadKDString((String)"\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u6e05\u7406\u3002", (String)"ClearLogUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), STATE_RUNNING);
        if (pageCache == null || params == null || params.size() <= 0 || range == null) {
            return;
        }
        boolean single = range.size() == 1;
        Timestamp startTime = new Timestamp(System.currentTimeMillis());
        StringBuilder remark = new StringBuilder();
        long totalNum = 0L;
        long id = ClearLogUtil.saveRecord(ResManager.loadKDString((String)"\u6e05\u7406\u65e5\u5fd7\u6b63\u5728\u8fdb\u884c\u4e2d", (String)"ClearLogUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), range, startTime, totalNum);
        try {
            for (Map.Entry<String, LogEnum> entry : params.entrySet()) {
                pageCache.put("totalNum", D.s((Object)totalNum));
                int delNum = ClearLogUtil.deleteLogs(entry.getValue(), range, isAllState, single, pageCache, index);
                remark.append(entry.getValue().getLogType()).append(':').append(delNum).append('\uff1b');
                ClearLogUtil.updateRecord(remark.toString(), STATE_RUNNING, totalNum += (long)delNum, id);
            }
        }
        catch (TaskCancelException e) {
            ClearLogUtil.buildRemark(params, pageCache, "cancelled", StringUtil.toString((Throwable)e), id);
            throw e;
        }
        catch (Exception e) {
            ClearLogUtil.buildRemark(params, pageCache, "failed", StringUtil.toString((Throwable)e), id);
            throw new IscBizException((Throwable)e);
        }
        ClearLogUtil.updateRecord(remark.toString(), "complete", totalNum, id);
    }

    private static long queryLogs(LogEnum logEnum, List<Object> range, boolean isAllState, boolean single) {
        if (logEnum == null || range == null) {
            return 0L;
        }
        long count = 0L;
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        String sql = "SELECT COUNT(*) FROM " + logEnum.getMasterTable() + ClearLogUtil.generateWhere(logEnum, single, isAllState);
        try {
            count = DbUtil.executeCount((Connection)cn, (String)sql, logEnum.changeRange(range), logEnum.getTypes(single));
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static int deleteLogs(LogEnum logEnum, List<Object> range, boolean isAllState, boolean single, IPageCache pageCache, AtomicInteger index) {
        block10: {
            if (logEnum == null || range == null) {
                return 0;
            }
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            reader = null;
            delNum = 0;
            sqlTop = "SELECT TOP 10000 FID FROM " + logEnum.getMasterTable() + ClearLogUtil.generateWhere(logEnum, single, isAllState);
            while (true) lbl-1000:
            // 3 sources

            {
                reader = DbUtil.executeQuery((Connection)cn, (String)sqlTop, logEnum.changeRange(range), logEnum.getTypes(single));
                try {
                    num = ClearLogUtil.deleteSql(cn, (ObjectReader<DataRow>)reader, logEnum, pageCache, index);
                    if (num != 0) {
                        delNum += num;
                    }
                    break block10;
                }
                finally {
                    DbUtil.close((ObjectReader)reader);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
            }
        }
        return delNum;
    }

    private static int deleteSql(Connection cn, ObjectReader<DataRow> reader, LogEnum logEnum, IPageCache pageCache, AtomicInteger index) {
        if (StringUtil.isEmpty((String)logEnum.getMasterTable())) {
            return 0;
        }
        int num = 0;
        DataRow row = (DataRow)reader.read();
        while (row != null) {
            SignalManager.checkCancelSignal();
            if (!StringUtil.isEmpty((String)logEnum.getSlaveTable())) {
                ClearLogUtil.executeSql(cn, logEnum.getSlaveTable(), "fid", D.s((Object)row.get((Object)"fid")));
            }
            if (!StringUtil.isEmpty((String)logEnum.getMlTable())) {
                ClearLogUtil.executeSql(cn, logEnum.getMlTable(), "fid", D.s((Object)row.get((Object)"fid")));
            }
            ClearLogUtil.executeSql(cn, logEnum.getMasterTable(), "fid", D.s((Object)row.get((Object)"fid")));
            index.incrementAndGet();
            ++num;
            long master = D.l((Object)pageCache.get(logEnum.getMasterTable()));
            pageCache.put(logEnum.getMasterTable(), D.s((Object)(++master)));
            long totalNum = D.l((Object)pageCache.get("totalNum"));
            pageCache.put("totalNum", D.s((Object)(++totalNum)));
            row = (DataRow)reader.read();
        }
        return num;
    }

    private static void executeSql(Connection cn, String table, String field, String fid) {
        if (StringUtil.isEmpty((String)table)) {
            return;
        }
        String slaveSql = ClearLogUtil.genDelSql(table, field, fid);
        DbUtil.executeUpdate((Connection)cn, (String)slaveSql);
    }

    private static String genDelSql(String table, String field, String fid) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(table);
        sql.append(" WHERE ").append(field).append("= '");
        sql.append(fid);
        sql.append('\'');
        return sql.toString();
    }

    private static String generateWhere(LogEnum logEnum, boolean single, boolean isAllState) {
        StringBuilder sql = new StringBuilder();
        if (single) {
            sql.append(" WHERE (").append(logEnum.getField()).append(" <=? )");
        } else {
            sql.append(" WHERE (").append(logEnum.getField()).append(" >=? AND ").append(logEnum.getField()).append(" <= ?)");
        }
        ClearLogUtil.handleWhereState(sql, logEnum, isAllState);
        return sql.toString();
    }

    private static void handleWhereState(StringBuilder sql, LogEnum logEnum, boolean isAllState) {
        if (isAllState) {
            if ("T_ISC_JOB_INST".equals(logEnum.getMasterTable())) {
                sql.append(" AND (FSTATE = 'FAILED' or FSTATE = 'COMPLETE')");
            } else if ("T_ISC_SF_PROC_INST".equals(logEnum.getMasterTable())) {
                sql.append(" AND (FSTATE = 'Failed' or FSTATE = 'Complete')");
            } else if ("T_DBC_TABLE_COPY_LOG".equals(logEnum.getMasterTable())) {
                sql.append(" AND (FSTATE = 'FAILED' or FSTATE = 'SUCCESS' or FSTATE = 'ABORTED')");
            }
        } else if (!StringUtil.isEmpty((String)logEnum.getField0())) {
            if ("T_ISC_SF_PROC_LOG".equals(logEnum.getMasterTable())) {
                sql.append(" AND (").append(logEnum.getField0()).append(" = ").append("'INFO')");
            } else if ("T_ISC_JOB_INST".equals(logEnum.getMasterTable())) {
                sql.append(" AND (").append(logEnum.getField0()).append(" = ").append("'COMPLETE')");
            } else if ("T_ISC_SF_PROC_INST".equals(logEnum.getMasterTable())) {
                sql.append(" AND (").append(logEnum.getField0()).append(" = ").append("'Complete')");
            } else if ("T_ISCB_BILL_LOG_RELATION".equals(logEnum.getMasterTable())) {
                sql.append(" AND (").append(logEnum.getField0()).append(" = ").append("'9')");
            } else if ("T_DBC_TABLE_COPY_LOG".equals(logEnum.getMasterTable())) {
                sql.append(" AND (").append(logEnum.getField0()).append(" = ").append("'SUCCESS')");
            } else {
                sql.append(" AND (").append(logEnum.getField0()).append(" = ").append("'S')");
            }
        }
    }

    public static DataRow getRecord() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        String sql = "SELECT FSTART_TIME,FOPERATOR_ID FROM T_ISCB_LOG_CLEANUP_LOG WHERE FSTART_TIME=(SELECT MAX(FSTART_TIME) FROM T_ISCB_LOG_CLEANUP_LOG)";
        DataRow dataRow = null;
        try {
            dataRow = DbUtil.executeRow((Connection)cn, (String)sql);
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return dataRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long saveRecord(String remark, List<Object> range, Timestamp startTime, Long totalCount) {
        if (range == null || remark == null) {
            return 0L;
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        long operatorId = UserServiceHelper.getCurrentUserId();
        long id = DB.genLongId((String)"T_ISCB_LOG_CLEANUP_LOG");
        String rangeTime = range.toString();
        String serverId = NetUtil.getServerId();
        String insert = "INSERT INTO T_ISCB_LOG_CLEANUP_LOG (FID,FSTART_TIME,FEND_TIME,FOPERATOR_ID,FLOG_TIME_RANGE,FSTATE,FREMARK,FREMARK_TAG,FTOTAL_COUNT,FSERVER_ID) VALUES (?,?,?,?,?,?,?,?,?,?)";
        List<Object> values = Arrays.asList(id, startTime, null, operatorId, rangeTime, STATE_RUNNING, StringUtil.trim((String)remark, (int)50), remark, totalCount, serverId);
        List<Integer> types = Arrays.asList(-5, 93, 93, -5, 12, 12, 12, 12, -5, 12);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)insert, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRecord(String remark, String state, Long totalCount, long id) {
        if (remark == null) {
            return;
        }
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        Timestamp endTime = new Timestamp(System.currentTimeMillis());
        String insert = "UPDATE T_ISCB_LOG_CLEANUP_LOG SET FEND_TIME=?, FSTATE=?, FREMARK=?, FREMARK_TAG=?, FTOTAL_COUNT=? WHERE FID=?";
        List<Object> values = Arrays.asList(endTime, state, StringUtil.trim((String)remark, (int)50), remark, totalCount, id);
        List<Integer> types = Arrays.asList(93, 12, 12, 12, -5, -5);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)insert, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRecord(String state, String remark, String condition) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        String insert = "UPDATE T_ISCB_LOG_CLEANUP_LOG SET FSTATE=?, FREMARK=?, FREMARK_TAG=? WHERE FSTATE=?";
        List<Object> values = Arrays.asList(state, StringUtil.trim((String)remark, (int)50), remark, condition);
        List<Integer> types = Arrays.asList(12, 12, 12, 12);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)insert, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static long getAllCounts(Map<String, LogEnum> params, List<Object> range, boolean isAllState) {
        long counts = 0L;
        if (params == null || params.size() <= 0 || range == null) {
            return counts;
        }
        boolean single = range.size() == 1;
        for (Map.Entry<String, LogEnum> entry : params.entrySet()) {
            counts += ClearLogUtil.queryLogs(entry.getValue(), range, isAllState, single);
        }
        return counts;
    }

    private static void buildRemark(Map<String, LogEnum> params, IPageCache pageCache, String state, String e, long id) {
        StringBuilder remark = new StringBuilder();
        for (Map.Entry<String, LogEnum> entry : params.entrySet()) {
            LogEnum logEnum = entry.getValue();
            remark.append(logEnum.getLogType());
            remark.append(':');
            remark.append(D.l((Object)pageCache.get(logEnum.getMasterTable())));
            remark.append('\uff1b');
        }
        remark.append(e);
        ClearLogUtil.updateRecord(remark.toString(), state, D.l((Object)pageCache.get("totalNum")), id);
    }
}

