/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.log.es;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.logorm.LogORM;
import kd.bos.logorm.impl.LogORMStandardImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.log.es.EsDynamicLogObjectUtil;
import kd.isc.iscb.platform.core.log.es.EsLogUtil;
import kd.isc.iscb.platform.core.log.es.RecordDependencySwith;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class LogHandler {
    public static final String ISC_LOG_PROXY = "isc_es_log_item";
    public static final String TIME = "opdate";
    public static final String KEYWORDS = "keywords";
    public static final String BILLID = "billid";
    public static final String BILLTYPE = "billtype";
    public static final String ID = "id";
    public static final String BILLDATA_TAG = "billdata_tag";
    public static final String BILLSTATE = "billstate";
    public static final String REVERTSTATE = "revertstate";
    private String metaNumber;
    private String tableName;
    private String sortTimeField;
    private List<String> keyWordFields;
    private boolean isBaseData;
    private List<String> dependMetas;
    private String stateField;

    public List<String> getKeyWordFields() {
        return this.keyWordFields;
    }

    public void setKeyWordFields(List<String> keyWordFields) {
        this.keyWordFields = keyWordFields;
    }

    public void setMetaNumber(String metaNumber) {
        this.metaNumber = metaNumber;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSortTimeField(String sortTimeField) {
        this.sortTimeField = sortTimeField;
    }

    public String getMetaNumber() {
        return this.metaNumber;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSortTimeField() {
        return this.sortTimeField;
    }

    public boolean isBaseData() {
        return this.isBaseData;
    }

    public void setBaseData(boolean baseData) {
        this.isBaseData = baseData;
    }

    public List<String> getDependMetas() {
        return this.dependMetas;
    }

    public void setDependMetas(List<String> dependMetas) {
        this.dependMetas = dependMetas;
    }

    public String getStateField() {
        return this.stateField;
    }

    public void setStateField(String stateField) {
        this.stateField = stateField;
    }

    public DynamicObject convertToLogRecord(DynamicObject log) {
        DynamicObject logProxy = BusinessDataServiceHelper.newDynamicObject((String)ISC_LOG_PROXY);
        logProxy.set(ID, log.get(ID));
        logProxy.set(TIME, log.get(this.getSortTimeField()));
        logProxy.set(KEYWORDS, (Object)this.generateKeyWords(log));
        logProxy.set(BILLID, log.get(ID));
        logProxy.set(BILLTYPE, (Object)log.getDataEntityType().getName());
        logProxy.set(BILLDATA_TAG, (Object)EsDynamicLogObjectUtil.objectToJson(log));
        logProxy.set(REVERTSTATE, (Object)"F");
        this.setStateField(log, logProxy);
        return logProxy;
    }

    private void setStateField(DynamicObject log, DynamicObject logProxy) {
        IDataEntityProperty stateProp;
        if (this.getStateField() != null && (stateProp = (IDataEntityProperty)log.getDataEntityType().getProperties().get((Object)this.getStateField())) instanceof ComboProp) {
            String comboTitle = ((ComboProp)stateProp).getItemByName(log.getString(this.getStateField()));
            logProxy.set(BILLSTATE, (Object)comboTitle);
        }
    }

    public DynamicObject revertToLogObj(long id) {
        QFilter qFilter = new QFilter(ID, "=", (Object)id);
        DynamicObjectCollection logRecords = LogORM.create().query(ISC_LOG_PROXY, "id,billtype,revertstate,billdata_tag", new QFilter[]{qFilter}, 1, 0);
        if (logRecords.size() == 1) {
            DynamicObject logRecord = (DynamicObject)logRecords.get(0);
            String logDataTag = logRecord.getString(BILLDATA_TAG);
            String entity = logRecord.getString(BILLTYPE);
            DynamicObject object = EsDynamicLogObjectUtil.jsonToObject(entity, logDataTag);
            if (RecordDependencySwith.needRecord()) {
                return this.postHandle(object);
            }
            return object;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"es\u4e2d\u5df2\u627e\u4e0d\u5230id\u4e3a[%s]\u7684\u65e5\u5fd7\u8bb0\u5f55", (String)"LogHandler_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), id));
    }

    private DynamicObject postHandle(DynamicObject obj) {
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"name")) {
            obj.set("name", (Object)String.format(ResManager.loadKDString((String)"\u3010ES\u8fd8\u539f\u3011%s", (String)"LogHandler_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), obj.getString("name")));
        } else if (properties.containsKey((Object)"number")) {
            obj.set("number", (Object)("\u3010ES\u3011" + obj.getString("number")));
        }
        return obj;
    }

    public void save(DynamicObject log) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1);
        list.add(this.convertToLogRecord(log));
        ((LogORMStandardImpl)LogORM.create()).save(list);
    }

    public void migrateDynamicObjToEs(List<Object> ids) {
        Object[] pks = ids.toArray(new Object[0]);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.metaNumber);
        DynamicObject[] logs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)dataEntityType);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(logs.length);
        long dataSize = 0L;
        for (DynamicObject log : logs) {
            DynamicObject e = this.convertToLogRecord(log);
            int length = e.getString(BILLDATA_TAG).length();
            list.add(e);
            if ((dataSize += (long)length) < EsLogUtil.getMaxEsBatchSize()) continue;
            ((LogORMStandardImpl)LogORM.create()).save(list);
            list = new ArrayList(logs.length);
            dataSize = 0L;
        }
        if (list.size() > 0) {
            ((LogORMStandardImpl)LogORM.create()).save(list);
        }
    }

    private String generateKeyWords(DynamicObject log) {
        StringBuilder sb = new StringBuilder();
        IDataEntityType dataEntityType = log.getDataEntityType();
        DataEntityPropertyCollection props = dataEntityType.getProperties();
        for (int i = 0; i < this.keyWordFields.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String propertyName = this.keyWordFields.get(i);
            IDataEntityProperty prop = (IDataEntityProperty)props.get((Object)propertyName);
            Object value = log.get(propertyName);
            if (value instanceof DynamicObject) {
                DynamicObject f7 = (DynamicObject)value;
                sb.append(f7.getString("number"));
                sb.append(f7.getString("name"));
                continue;
            }
            if (value instanceof OrmLocaleValue) {
                sb.append(((OrmLocaleValue)value).getLocaleValue_zh_CN());
                continue;
            }
            if (value instanceof Number) {
                long id = D.l((Object)value);
                if (id <= 0L) continue;
                this.appendKeyWordIfPropTypeIsF7(sb, log, prop, id);
                continue;
            }
            sb.append(D.s((Object)value));
        }
        if (sb.length() > 256) {
            return sb.substring(0, 256);
        }
        return sb.toString();
    }

    private void appendKeyWordIfPropTypeIsF7(StringBuilder sb, DynamicObject log, IDataEntityProperty prop, long id) {
        String metaNumber = null;
        if (prop instanceof ItemClassProp) {
            String typePropName = ((ItemClassProp)prop).getTypePropName();
            metaNumber = log.getString(typePropName);
        } else if (prop instanceof BasedataProp) {
            metaNumber = ((BasedataProp)prop).getBaseEntityId();
        }
        if (metaNumber != null) {
            DynamicObject f7 = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)metaNumber, (String)"number,name");
            sb.append(f7.getString("number"));
            sb.append(f7.getString("name"));
        }
    }
}

