/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.log.es;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logorm.LogORM;
import kd.bos.logorm.impl.LogORMStandardImpl;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.log.es.EsLogUtil;
import kd.isc.iscb.platform.core.log.es.LogHandler;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class ProcInstHandler
extends LogHandler {
    private LogHandler logHandler;
    private List<String> fields;
    private String fieldString;

    public ProcInstHandler(LogHandler logHandler) {
        this.initFields();
        this.fieldString = StringUtil.join(this.fields, (String)",");
        this.logHandler = logHandler;
        this.setBaseData(logHandler.isBaseData());
        this.setMetaNumber(logHandler.getMetaNumber());
        this.setDependMetas(logHandler.getDependMetas());
        this.setKeyWordFields(logHandler.getKeyWordFields());
        this.setSortTimeField(logHandler.getSortTimeField());
        this.setStateField(logHandler.getStateField());
        this.setTableName(logHandler.getTableName());
    }

    private void initFields() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"isc_sf_proc_inst");
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        this.fields = new ArrayList<String>(properties.size());
        for (IDataEntityProperty property : properties) {
            if (D.s((Object)property.getAlias()) == null) continue;
            this.fields.add(property.getName());
        }
    }

    @Override
    public void migrateDynamicObjToEs(List<Object> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet("isc_find_proc_for_es", this.logHandler.getMetaNumber(), this.fieldString, new QFilter[]{qFilter});){
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            long dataSize = 0L;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                DynamicObject e = this.convertRowToLogRecord(row);
                list.add(e);
                if ((dataSize += (long)e.getString("billdata_tag").length()) < EsLogUtil.getMaxEsBatchSize()) continue;
                list = new ArrayList(10);
                dataSize = 0L;
                ((LogORMStandardImpl)LogORM.create()).save(list);
            }
            if (list.size() > 0) {
                ((LogORMStandardImpl)LogORM.create()).save(list);
            }
        }
    }

    private DynamicObject convertRowToLogRecord(Row row) {
        DynamicObject log = this.convertRowToObject(row);
        return super.convertToLogRecord(log);
    }

    private DynamicObject convertRowToObject(Row row) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)this.logHandler.getMetaNumber());
        for (String s : this.fields) {
            obj.set(s, row.get(s));
        }
        return obj;
    }
}

