/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.mapping.bean.FieldMappingItem;
import kd.isc.iscb.platform.core.mapping.bean.PropertyModel;
import kd.isc.iscb.platform.core.mapping.stringsimilarity.StringSimilarity;
import kd.isc.iscb.platform.core.mapping.stringsimilarity.StringSimilarityUtil;
import kd.isc.iscb.platform.core.mapping.util.PropertyUtil;
import kd.isc.iscb.util.misc.Pair;

public class AutoMapProcess {
    private Map<String, PropertyModel> srcPropModels;
    private Map<String, PropertyModel> tarPropModels;
    private StringSimilarity algorithm;
    private double matchRatio;

    public AutoMapProcess(long sourceSchemaId, long targetSchemaId, String algorithm, double matchRatio) {
        this(sourceSchemaId, targetSchemaId, "", "", "", "", algorithm, matchRatio);
    }

    public AutoMapProcess(long sourceSchemaId, long targetSchemaId, String srcNamePrefix, String srcLabelPrefix, String tarNamePrefix, String tarLabelPrefix, String algorithm, double matchRatio) {
        this.checkArgs(sourceSchemaId, targetSchemaId);
        this.srcPropModels = PropertyUtil.initPropertyMap(sourceSchemaId, srcNamePrefix, srcLabelPrefix);
        this.tarPropModels = PropertyUtil.initPropertyMap(targetSchemaId, tarNamePrefix, tarLabelPrefix);
        this.algorithm = StringSimilarityUtil.findSimilarityAlgorithm(algorithm);
        this.initMatchRatio(matchRatio);
    }

    private void initMatchRatio(double matchRatio) {
        if (matchRatio < 0.1) {
            matchRatio = 0.1;
        }
        if (matchRatio > 1.0) {
            matchRatio = 1.0;
        }
        this.matchRatio = matchRatio;
    }

    private Map<String, PropertyModel> initNameToPropModelsMap(Map<String, PropertyModel> propModels) {
        Collection<PropertyModel> values = propModels.values();
        HashMap<String, PropertyModel> map = new HashMap<String, PropertyModel>(values.size());
        for (PropertyModel tarProp : values) {
            map.put(tarProp.getLabel(), tarProp);
        }
        return map;
    }

    public AutoMapProcess(Map<String, PropertyModel> srcPropModels, Map<String, PropertyModel> tarPropModels, StringSimilarity algorithm, double matchRatio) {
        this.srcPropModels = srcPropModels;
        this.tarPropModels = tarPropModels;
        this.algorithm = algorithm;
        this.matchRatio = matchRatio;
    }

    public List<FieldMappingItem> handle() {
        Map<String, PropertyModel> srcNameToPropModelsMap = this.initNameToPropModelsMap(this.srcPropModels);
        ArrayList<FieldMappingItem> list = new ArrayList<FieldMappingItem>(this.tarPropModels.size());
        for (Map.Entry<String, PropertyModel> tarEntry : this.tarPropModels.entrySet()) {
            this.addMappingItem(srcNameToPropModelsMap, list, tarEntry);
        }
        this.sort(list);
        return list;
    }

    private void addMappingItem(Map<String, PropertyModel> srcNameToPropModelsMap, List<FieldMappingItem> list, Map.Entry<String, PropertyModel> tarEntry) {
        PropertyModel tarProp = tarEntry.getValue();
        FieldMappingItem mappingItem = this.initMappingItem(tarProp, this.srcPropModels, srcNameToPropModelsMap);
        if (this.hasFoundMappingItem(mappingItem) && mappingItem.getSimilar() >= this.matchRatio) {
            list.add(mappingItem);
        } else {
            list.add(new FieldMappingItem(tarProp, null, 0.0, this.algorithm, this.matchRatio));
        }
    }

    private void sort(List<FieldMappingItem> list) {
        Collections.sort(list, new Comparator<FieldMappingItem>(){

            @Override
            public int compare(FieldMappingItem o1, FieldMappingItem o2) {
                PropertyModel o2TarProp;
                PropertyModel o1TarProp = o1.getTarProp();
                if (AutoMapProcess.this.bothAreEntryType(o1TarProp, o2TarProp = o2.getTarProp())) {
                    return 0;
                }
                if (AutoMapProcess.this.bothAreNotEntryType(o1TarProp, o2TarProp)) {
                    return 0;
                }
                if (o1TarProp.isEntry()) {
                    return 1;
                }
                return -1;
            }
        });
    }

    private boolean hasFoundMappingItem(FieldMappingItem mappingItem) {
        return mappingItem != null && mappingItem.getSrcProp() != null;
    }

    private FieldMappingItem initMappingItem(PropertyModel prop, Map<String, PropertyModel> propModelsToCompare, Map<String, PropertyModel> nameToPropModelMap) {
        if (propModelsToCompare == null || propModelsToCompare.size() == 0) {
            return null;
        }
        PropertyModel matchProp = propModelsToCompare.get(prop.getName());
        if (matchProp != null) {
            return this.checkEntryTypeAndMapping(prop, matchProp, propModelsToCompare);
        }
        matchProp = nameToPropModelMap.get(prop.getLabel());
        if (matchProp != null) {
            return this.checkEntryTypeAndMapping(prop, matchProp, propModelsToCompare);
        }
        return this.getFieldMappingItem(prop, propModelsToCompare);
    }

    private FieldMappingItem checkEntryTypeAndMapping(PropertyModel prop, PropertyModel matchProp, Map<String, PropertyModel> propModelsToCompare) {
        if (this.bothAreEntryType(prop, matchProp)) {
            return new FieldMappingItem(prop, matchProp, 1.0, this.algorithm, this.matchRatio);
        }
        if (this.bothAreNotEntryType(prop, matchProp)) {
            return new FieldMappingItem(prop, matchProp, 1.0, this.algorithm, this.matchRatio);
        }
        return this.getFieldMappingItem(prop, propModelsToCompare);
    }

    private FieldMappingItem getFieldMappingItem(PropertyModel prop, Map<String, PropertyModel> propModelsToCompare) {
        Pair<PropertyModel, Double> pair = this.findMostSimilarPropFromModels(prop, propModelsToCompare.values());
        return new FieldMappingItem(prop, (PropertyModel)pair.getKey(), (Double)pair.getValue(), this.algorithm, this.matchRatio);
    }

    private boolean bothAreNotEntryType(PropertyModel prop, PropertyModel matchProp) {
        return !prop.isEntry() && !matchProp.isEntry();
    }

    private boolean bothAreEntryType(PropertyModel prop, PropertyModel matchProp) {
        return prop.isEntry() && matchProp.isEntry();
    }

    private Pair<PropertyModel, Double> findMostSimilarPropFromModels(PropertyModel srcProp, Collection<PropertyModel> propModels) {
        PropertyModel mostSimilarProp = null;
        double mostSimilar = 0.0;
        for (PropertyModel tarModel : propModels) {
            if (this.onlyOnePropTypeIsEntry(srcProp, tarModel)) continue;
            double similar = this.calcSimilarIgnoreCase(srcProp.getName(), tarModel.getName());
            int compare = Double.compare(similar, 1.0);
            if (compare == 0) {
                return new Pair((Object)tarModel, (Object)1.0);
            }
            if (!(similar > mostSimilar)) continue;
            mostSimilar = similar;
            mostSimilarProp = tarModel;
        }
        return new Pair(mostSimilarProp, (Object)mostSimilar);
    }

    private boolean onlyOnePropTypeIsEntry(PropertyModel srcProp, PropertyModel tarModel) {
        if (srcProp.isEntry() && !tarModel.isEntry()) {
            return true;
        }
        return !srcProp.isEntry() && tarModel.isEntry();
    }

    private double calcSimilarIgnoreCase(String srcPropName, String tarPropName) {
        return this.algorithm.calculate(srcPropName.toLowerCase(Locale.ENGLISH), tarPropName.toLowerCase(Locale.ENGLISH));
    }

    private void checkArgs(long sourceSchemaId, long targetSchemaId) {
        if (sourceSchemaId <= 0L) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u96c6\u6210\u5bf9\u8c61\u518d\u6267\u884c\u81ea\u52a8\u6620\u5c04", (String)"AutoMapProcess_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (targetSchemaId <= 0L) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\u518d\u6267\u884c\u81ea\u52a8\u6620\u5c04", (String)"AutoMapProcess_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }
}

