/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.mapping.stringsimilarity;

import kd.isc.iscb.platform.core.mapping.stringsimilarity.StringSimilarity;

public class LongestCommonSubsquence
implements StringSimilarity {
    public static final LongestCommonSubsquence INSTANCE = new LongestCommonSubsquence();

    private LongestCommonSubsquence() {
    }

    @Override
    public double calculate(CharSequence left, CharSequence right) {
        if (left != null && right != null) {
            int leftSz = left.length();
            int rightSz = right.length();
            if (leftSz != 0 && rightSz != 0) {
                int commonLength = leftSz < rightSz ? LongestCommonSubsquence.findCommonLength(right, left)[leftSz] : LongestCommonSubsquence.findCommonLength(left, right)[rightSz];
                double numberator = (double)commonLength * (double)commonLength;
                double denominator = (double)leftSz * (double)rightSz;
                return Math.sqrt(numberator / denominator);
            }
            if (leftSz == 0 && rightSz == 0) {
                return 1.0;
            }
            return 0.0;
        }
        throw new IllegalArgumentException("Inputs must not be null");
    }

    private static int[] findCommonLength(CharSequence left, CharSequence right) {
        int m = left.length();
        int n = right.length();
        int[][] dpRows = new int[2][1 + n];
        for (int i = 1; i <= m; ++i) {
            int[] temp = dpRows[0];
            dpRows[0] = dpRows[1];
            dpRows[1] = temp;
            for (int j = 1; j <= n; ++j) {
                dpRows[1][j] = left.charAt(i - 1) == right.charAt(j - 1) ? dpRows[0][j - 1] + 1 : Math.max(dpRows[1][j - 1], dpRows[0][j]);
            }
        }
        return dpRows[1];
    }
}

