/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.mapping.stringsimilarity;

import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.mapping.stringsimilarity.Jaccard;
import kd.isc.iscb.platform.core.mapping.stringsimilarity.LongestCommonSubsquence;
import kd.isc.iscb.platform.core.mapping.stringsimilarity.StringSimilarity;

public class StringSimilarityUtil {
    public static double calculateSimilarity(String algorithm, CharSequence left, CharSequence right) {
        StringSimilarity similarity = StringSimilarityUtil.findSimilarityAlgorithm(algorithm);
        return similarity.calculate(left, right);
    }

    public static StringSimilarity findSimilarityAlgorithm(String algorithm) {
        if (algorithm == null) {
            return LongestCommonSubsquence.INSTANCE;
        }
        return StringSimilarityUtil.innerFindSimilarityAlgorithm(algorithm);
    }

    private static StringSimilarity innerFindSimilarityAlgorithm(String algorithm) {
        if ("Jaccard".equals(algorithm)) {
            return Jaccard.INSTANCE;
        }
        if ("LongestCommonSubsquence".equals(algorithm)) {
            return LongestCommonSubsquence.INSTANCE;
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u4e32\u76f8\u4f3c\u5ea6\u7b97\u6cd5\uff1a%s", (String)"StringSimilarityUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), algorithm));
    }
}

