/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.ServiceUtil;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;

public class MetaSchemaAccessor {
    public static Object run(DynamicObject meta, Method method, Map<String, Object> params, String proxy_user) {
        Type type = Type.valueOf(meta.getString("type"));
        if (!type.supports(method)) {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\uff08%s\uff09\u6d4b\u8bd5\u65b9\u6cd5\u3002", (String)"MetaSchemaAccessor_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), new Object[]{method}));
        }
        ConnectionWrapper cn = MetaSchemaAccessor.createConnection(meta);
        switch (method) {
            case READ: {
                return type.read(cn, meta, params, proxy_user);
            }
            case WRITE: {
                return type.write(cn, meta, params, proxy_user);
            }
            case EXECUTE: {
                return type.execute(cn, meta, params, proxy_user);
            }
        }
        throw new UnsupportedOperationException(method.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionWrapper createConnection(DynamicObject meta) {
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(meta));
        try {
            ConnectionWrapper cn;
            DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)meta.getLong("group_id"), (String)"isc_data_source");
            ConnectionWrapper connectionWrapper = cn = ConnectionManager.getConnection((Long)dataSource.get("dblink_id"));
            return connectionWrapper;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private static enum Type {
        TABLE{

            @Override
            boolean supports(Method method) {
                return Method.WRITE == method || Method.READ == method;
            }
        }
        ,
        VIEW{

            @Override
            boolean supports(Method method) {
                return Method.READ == method;
            }
        }
        ,
        ENTITY{

            @Override
            boolean supports(Method method) {
                return Method.WRITE == method || Method.READ == method;
            }
        }
        ,
        SERVICE{

            @Override
            boolean supports(Method method) {
                return Method.EXECUTE == method || Method.WRITE == method;
            }

            @Override
            protected Object execute(ConnectionWrapper cn, DynamicObject meta, Map<String, Object> data, String proxy_user) {
                return ServiceUtil.callService(cn, meta, data, proxy_user);
            }

            @Override
            protected Object write(ConnectionWrapper cn, DynamicObject meta, Map<String, Object> data, String proxy_user) {
                return ServiceUtil.callService(cn, meta, data, proxy_user);
            }
        }
        ,
        QUERY{

            @Override
            boolean supports(Method method) {
                return Method.EXECUTE == method || Method.READ == method;
            }

            @Override
            protected Object execute(ConnectionWrapper cn, DynamicObject meta, Map<String, Object> data, String proxy_user) {
                return ServiceUtil.callService(cn, meta, data, proxy_user);
            }

            @Override
            protected Object read(ConnectionWrapper cn, DynamicObject meta, Map<String, Object> data, String proxy_user) {
                return ServiceUtil.callService(cn, meta, data, proxy_user);
            }
        }
        ,
        STRUCT{

            @Override
            boolean supports(Method method) {
                return false;
            }
        };


        abstract boolean supports(Method var1);

        protected Object execute(ConnectionWrapper cn, DynamicObject meta, Map<String, Object> data, String proxy_user) {
            throw new UnsupportedOperationException(this.name() + ".execute");
        }

        protected Object write(ConnectionWrapper cn, DynamicObject meta, Map<String, Object> data, String proxy_user) {
            throw new UnsupportedOperationException(this.name() + ".write");
        }

        protected Object read(ConnectionWrapper cn, DynamicObject meta, Map<String, Object> data, String proxy_user) {
            throw new UnsupportedOperationException(this.name() + ".read");
        }
    }

    public static enum Method {
        READ,
        WRITE,
        EXECUTE;

    }
}

