/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.meta.SyncMetaJobFactory;

public class SyncMetaListTask {
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_MODIFY_TIME = "modify_time";
    private static final String FIELD_STATE = "state";

    public static boolean start(long dataSourceId, boolean syncAll, String pageId) {
        if (SyncMetaListTask.isRunning(dataSourceId)) {
            return false;
        }
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source", (String)"number");
        String number = dataSource.getString("number");
        Job job = SyncMetaJobFactory.createJob(dataSourceId, number);
        JobEngine.submit(job);
        return true;
    }

    public static boolean isRunning(Object dataSourceId) {
        DynamicObject[] logs;
        QFilter filter = new QFilter(FIELD_STATE, "=", (Object)"R");
        filter.and(new QFilter("data_source", "=", dataSourceId));
        for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"isc_sync_meta_log", (String)"id, state, create_time, modify_time, message", (QFilter[])new QFilter[]{filter})) {
            Timestamp modifyTime = (Timestamp)log.get(FIELD_MODIFY_TIME);
            if (modifyTime != null && System.currentTimeMillis() - modifyTime.getTime() > 1800000L) {
                log.set(FIELD_STATE, (Object)"F");
                log.set(FIELD_MESSAGE, (Object)ResManager.loadKDString((String)"\u8d85\u8fc730\u5206\u949f\u672a\u66f4\u65b0\u72b6\u6001\uff0c\u4efb\u52a1\u5931\u8d25", (String)"SyncMetaListTask_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                log.set(FIELD_MODIFY_TIME, (Object)Timestamp.valueOf(LocalDateTime.now()));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
                continue;
            }
            Timestamp createTime = (Timestamp)log.get("create_time");
            long internal = System.currentTimeMillis() - createTime.getTime();
            if (internal < 18000000L) {
                return true;
            }
            log.set(FIELD_STATE, (Object)"T");
            log.set(FIELD_MODIFY_TIME, (Object)Timestamp.valueOf(LocalDateTime.now()));
            log.set(FIELD_MESSAGE, (Object)ResManager.loadKDString((String)"\u8d85\u65f6\u63d0\u524d\u7ec8\u6b62", (String)"SyncMetaListTask_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
        return false;
    }
}

